package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import java.lang.Object;

public class APIServerFluentImpl<A extends APIServerFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements APIServerFluent<A> {

    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private APIServerSpecBuilder spec;
    private APIServerStatusBuilder status;

    public APIServerFluentImpl() {
    }

    public APIServerFluentImpl(APIServer instance) {
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    public APIServerFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    public APIServerFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    public APIServerFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public APIServerFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public APIServerFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public APIServerSpec getSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public APIServerSpec buildSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(APIServerSpec spec) {
        _visitables.get("spec").remove(this.spec);
        if (spec!=null){ this.spec= new APIServerSpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public Boolean hasSpec() {
        return this.spec != null;
    }

    public APIServerFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    public APIServerFluent.SpecNested<A> withNewSpecLike(APIServerSpec item) {
        return new SpecNestedImpl(item);
    }

    public APIServerFluent.SpecNested<A> editSpec() {
        return withNewSpecLike(getSpec());
    }

    public APIServerFluent.SpecNested<A> editOrNewSpec() {
        return withNewSpecLike(getSpec() != null ? getSpec(): new APIServerSpecBuilder().build());
    }

    public APIServerFluent.SpecNested<A> editOrNewSpecLike(APIServerSpec item) {
        return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public APIServerStatus getStatus() {
        return this.status!=null?this.status.build():null;
    }

    public APIServerStatus buildStatus() {
        return this.status!=null?this.status.build():null;
    }

    public A withStatus(APIServerStatus status) {
        _visitables.get("status").remove(this.status);
        if (status!=null){ this.status= new APIServerStatusBuilder(status); _visitables.get("status").add(this.status);} return (A) this;
    }

    public Boolean hasStatus() {
        return this.status != null;
    }

    public APIServerFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    public APIServerFluent.StatusNested<A> withNewStatusLike(APIServerStatus item) {
        return new StatusNestedImpl(item);
    }

    public APIServerFluent.StatusNested<A> editStatus() {
        return withNewStatusLike(getStatus());
    }

    public APIServerFluent.StatusNested<A> editOrNewStatus() {
        return withNewStatusLike(getStatus() != null ? getStatus(): new APIServerStatusBuilder().build());
    }

    public APIServerFluent.StatusNested<A> editOrNewStatusLike(APIServerStatus item) {
        return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        APIServerFluentImpl that = (APIServerFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
        if (status != null ? !status.equals(that.status) :that.status != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  super.hashCode());
    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<APIServerFluent.MetadataNested<N>> implements APIServerFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ObjectMetaBuilder builder;

            MetadataNestedImpl(ObjectMeta item) {
                this.builder = new ObjectMetaBuilder(this, item);
                        
            }

            MetadataNestedImpl() {
                this.builder = new ObjectMetaBuilder(this);
                        
            }

            public N and() {
                return (N) APIServerFluentImpl.this.withMetadata(builder.build());
            }

            public N endMetadata() {
                return and();
            }
    }


    public class SpecNestedImpl<N> extends APIServerSpecFluentImpl<APIServerFluent.SpecNested<N>> implements APIServerFluent.SpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final APIServerSpecBuilder builder;

            SpecNestedImpl(APIServerSpec item) {
                this.builder = new APIServerSpecBuilder(this, item);
                        
            }

            SpecNestedImpl() {
                this.builder = new APIServerSpecBuilder(this);
                        
            }

            public N and() {
                return (N) APIServerFluentImpl.this.withSpec(builder.build());
            }

            public N endSpec() {
                return and();
            }
    }


    public class StatusNestedImpl<N> extends APIServerStatusFluentImpl<APIServerFluent.StatusNested<N>> implements APIServerFluent.StatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final APIServerStatusBuilder builder;

            StatusNestedImpl(APIServerStatus item) {
                this.builder = new APIServerStatusBuilder(this, item);
                        
            }

            StatusNestedImpl() {
                this.builder = new APIServerStatusBuilder(this);
                        
            }

            public N and() {
                return (N) APIServerFluentImpl.this.withStatus(builder.build());
            }

            public N endStatus() {
                return and();
            }
    }


}
