package io.fabric8.openshift.api.model;

import java.lang.Integer;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class ClusterNetworkEntryFluentImpl<A extends ClusterNetworkEntryFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ClusterNetworkEntryFluent<A> {

    private String cidr;
    private Integer hostSubnetLength;

    public ClusterNetworkEntryFluentImpl() {
    }

    public ClusterNetworkEntryFluentImpl(ClusterNetworkEntry instance) {
        this.withCidr(instance.getCidr()); 
        this.withHostSubnetLength(instance.getHostSubnetLength()); 
    }

    public String getCidr() {
        return this.cidr;
    }

    public A withCidr(String cidr) {
        this.cidr=cidr; return (A) this;
    }

    public Boolean hasCidr() {
        return this.cidr != null;
    }

    public A withNewCidr(String arg1) {
        return (A)withCidr(new String(arg1));
    }

    public A withNewCidr(StringBuilder arg1) {
        return (A)withCidr(new String(arg1));
    }

    public A withNewCidr(StringBuffer arg1) {
        return (A)withCidr(new String(arg1));
    }

    public Integer getHostSubnetLength() {
        return this.hostSubnetLength;
    }

    public A withHostSubnetLength(Integer hostSubnetLength) {
        this.hostSubnetLength=hostSubnetLength; return (A) this;
    }

    public Boolean hasHostSubnetLength() {
        return this.hostSubnetLength != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ClusterNetworkEntryFluentImpl that = (ClusterNetworkEntryFluentImpl) o;
        if (cidr != null ? !cidr.equals(that.cidr) :that.cidr != null) return false;
        if (hostSubnetLength != null ? !hostSubnetLength.equals(that.hostSubnetLength) :that.hostSubnetLength != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(cidr,  hostSubnetLength,  super.hashCode());
    }

}
