package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OvirtPlatformStatusBuilder extends OvirtPlatformStatusFluentImpl<OvirtPlatformStatusBuilder> implements VisitableBuilder<OvirtPlatformStatus,OvirtPlatformStatusBuilder> {

    OvirtPlatformStatusFluent<?> fluent;
    Boolean validationEnabled;

    public OvirtPlatformStatusBuilder() {
        this(true);
    }

    public OvirtPlatformStatusBuilder(Boolean validationEnabled) {
        this(new OvirtPlatformStatus(), validationEnabled);
    }

    public OvirtPlatformStatusBuilder(OvirtPlatformStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public OvirtPlatformStatusBuilder(OvirtPlatformStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new OvirtPlatformStatus(), validationEnabled);
    }

    public OvirtPlatformStatusBuilder(OvirtPlatformStatusFluent<?> fluent,OvirtPlatformStatus instance) {
        this(fluent, instance, true);
    }

    public OvirtPlatformStatusBuilder(OvirtPlatformStatusFluent<?> fluent,OvirtPlatformStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiServerInternalIP(instance.getApiServerInternalIP()); 
        fluent.withIngressIP(instance.getIngressIP()); 
        fluent.withNodeDNSIP(instance.getNodeDNSIP()); 
        this.validationEnabled = validationEnabled; 
    }

    public OvirtPlatformStatusBuilder(OvirtPlatformStatus instance) {
        this(instance,true);
    }

    public OvirtPlatformStatusBuilder(OvirtPlatformStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiServerInternalIP(instance.getApiServerInternalIP()); 
        this.withIngressIP(instance.getIngressIP()); 
        this.withNodeDNSIP(instance.getNodeDNSIP()); 
        this.validationEnabled = validationEnabled; 
    }

    public OvirtPlatformStatus build() {
        OvirtPlatformStatus buildable = new OvirtPlatformStatus(fluent.getApiServerInternalIP(),fluent.getIngressIP(),fluent.getNodeDNSIP());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        OvirtPlatformStatusBuilder that = (OvirtPlatformStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
