package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class PodSecurityPolicyReviewFluentImpl<A extends PodSecurityPolicyReviewFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PodSecurityPolicyReviewFluent<A> {

    private String apiVersion;
    private String kind;
    private PodSecurityPolicyReviewSpecBuilder spec;
    private PodSecurityPolicyReviewStatusBuilder status;

    public PodSecurityPolicyReviewFluentImpl() {
    }

    public PodSecurityPolicyReviewFluentImpl(PodSecurityPolicyReview instance) {
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public PodSecurityPolicyReviewSpec getSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public PodSecurityPolicyReviewSpec buildSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(PodSecurityPolicyReviewSpec spec) {
        _visitables.get("spec").remove(this.spec);
        if (spec!=null){ this.spec= new PodSecurityPolicyReviewSpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public Boolean hasSpec() {
        return this.spec != null;
    }

    public PodSecurityPolicyReviewFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    public PodSecurityPolicyReviewFluent.SpecNested<A> withNewSpecLike(PodSecurityPolicyReviewSpec item) {
        return new SpecNestedImpl(item);
    }

    public PodSecurityPolicyReviewFluent.SpecNested<A> editSpec() {
        return withNewSpecLike(getSpec());
    }

    public PodSecurityPolicyReviewFluent.SpecNested<A> editOrNewSpec() {
        return withNewSpecLike(getSpec() != null ? getSpec(): new PodSecurityPolicyReviewSpecBuilder().build());
    }

    public PodSecurityPolicyReviewFluent.SpecNested<A> editOrNewSpecLike(PodSecurityPolicyReviewSpec item) {
        return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public PodSecurityPolicyReviewStatus getStatus() {
        return this.status!=null?this.status.build():null;
    }

    public PodSecurityPolicyReviewStatus buildStatus() {
        return this.status!=null?this.status.build():null;
    }

    public A withStatus(PodSecurityPolicyReviewStatus status) {
        _visitables.get("status").remove(this.status);
        if (status!=null){ this.status= new PodSecurityPolicyReviewStatusBuilder(status); _visitables.get("status").add(this.status);} return (A) this;
    }

    public Boolean hasStatus() {
        return this.status != null;
    }

    public PodSecurityPolicyReviewFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    public PodSecurityPolicyReviewFluent.StatusNested<A> withNewStatusLike(PodSecurityPolicyReviewStatus item) {
        return new StatusNestedImpl(item);
    }

    public PodSecurityPolicyReviewFluent.StatusNested<A> editStatus() {
        return withNewStatusLike(getStatus());
    }

    public PodSecurityPolicyReviewFluent.StatusNested<A> editOrNewStatus() {
        return withNewStatusLike(getStatus() != null ? getStatus(): new PodSecurityPolicyReviewStatusBuilder().build());
    }

    public PodSecurityPolicyReviewFluent.StatusNested<A> editOrNewStatusLike(PodSecurityPolicyReviewStatus item) {
        return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PodSecurityPolicyReviewFluentImpl that = (PodSecurityPolicyReviewFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
        if (status != null ? !status.equals(that.status) :that.status != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  kind,  spec,  status,  super.hashCode());
    }

    public class SpecNestedImpl<N> extends PodSecurityPolicyReviewSpecFluentImpl<PodSecurityPolicyReviewFluent.SpecNested<N>> implements PodSecurityPolicyReviewFluent.SpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodSecurityPolicyReviewSpecBuilder builder;

            SpecNestedImpl(PodSecurityPolicyReviewSpec item) {
                this.builder = new PodSecurityPolicyReviewSpecBuilder(this, item);
                        
            }

            SpecNestedImpl() {
                this.builder = new PodSecurityPolicyReviewSpecBuilder(this);
                        
            }

            public N and() {
                return (N) PodSecurityPolicyReviewFluentImpl.this.withSpec(builder.build());
            }

            public N endSpec() {
                return and();
            }
    }


    public class StatusNestedImpl<N> extends PodSecurityPolicyReviewStatusFluentImpl<PodSecurityPolicyReviewFluent.StatusNested<N>> implements PodSecurityPolicyReviewFluent.StatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodSecurityPolicyReviewStatusBuilder builder;

            StatusNestedImpl(PodSecurityPolicyReviewStatus item) {
                this.builder = new PodSecurityPolicyReviewStatusBuilder(this, item);
                        
            }

            StatusNestedImpl() {
                this.builder = new PodSecurityPolicyReviewStatusBuilder(this);
                        
            }

            public N and() {
                return (N) PodSecurityPolicyReviewFluentImpl.this.withStatus(builder.build());
            }

            public N endStatus() {
                return and();
            }
    }


}
