package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PodSecurityPolicySubjectReviewBuilder extends PodSecurityPolicySubjectReviewFluentImpl<PodSecurityPolicySubjectReviewBuilder> implements VisitableBuilder<PodSecurityPolicySubjectReview,PodSecurityPolicySubjectReviewBuilder> {

    PodSecurityPolicySubjectReviewFluent<?> fluent;
    Boolean validationEnabled;

    public PodSecurityPolicySubjectReviewBuilder() {
        this(true);
    }

    public PodSecurityPolicySubjectReviewBuilder(Boolean validationEnabled) {
        this(new PodSecurityPolicySubjectReview(), validationEnabled);
    }

    public PodSecurityPolicySubjectReviewBuilder(PodSecurityPolicySubjectReviewFluent<?> fluent) {
        this(fluent, true);
    }

    public PodSecurityPolicySubjectReviewBuilder(PodSecurityPolicySubjectReviewFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new PodSecurityPolicySubjectReview(), validationEnabled);
    }

    public PodSecurityPolicySubjectReviewBuilder(PodSecurityPolicySubjectReviewFluent<?> fluent,PodSecurityPolicySubjectReview instance) {
        this(fluent, instance, true);
    }

    public PodSecurityPolicySubjectReviewBuilder(PodSecurityPolicySubjectReviewFluent<?> fluent,PodSecurityPolicySubjectReview instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public PodSecurityPolicySubjectReviewBuilder(PodSecurityPolicySubjectReview instance) {
        this(instance,true);
    }

    public PodSecurityPolicySubjectReviewBuilder(PodSecurityPolicySubjectReview instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public PodSecurityPolicySubjectReview build() {
        PodSecurityPolicySubjectReview buildable = new PodSecurityPolicySubjectReview(fluent.getApiVersion(),fluent.getKind(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PodSecurityPolicySubjectReviewBuilder that = (PodSecurityPolicySubjectReviewBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
