package io.fabric8.openshift.api.model;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class AzurePlatformStatusFluentImpl<A extends AzurePlatformStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements AzurePlatformStatusFluent<A> {

    private String cloudName;
    private String networkResourceGroupName;
    private String resourceGroupName;

    public AzurePlatformStatusFluentImpl() {
    }

    public AzurePlatformStatusFluentImpl(AzurePlatformStatus instance) {
        this.withCloudName(instance.getCloudName()); 
        this.withNetworkResourceGroupName(instance.getNetworkResourceGroupName()); 
        this.withResourceGroupName(instance.getResourceGroupName()); 
    }

    public String getCloudName() {
        return this.cloudName;
    }

    public A withCloudName(String cloudName) {
        this.cloudName=cloudName; return (A) this;
    }

    public Boolean hasCloudName() {
        return this.cloudName != null;
    }

    public A withNewCloudName(String arg1) {
        return (A)withCloudName(new String(arg1));
    }

    public A withNewCloudName(StringBuilder arg1) {
        return (A)withCloudName(new String(arg1));
    }

    public A withNewCloudName(StringBuffer arg1) {
        return (A)withCloudName(new String(arg1));
    }

    public String getNetworkResourceGroupName() {
        return this.networkResourceGroupName;
    }

    public A withNetworkResourceGroupName(String networkResourceGroupName) {
        this.networkResourceGroupName=networkResourceGroupName; return (A) this;
    }

    public Boolean hasNetworkResourceGroupName() {
        return this.networkResourceGroupName != null;
    }

    public A withNewNetworkResourceGroupName(String arg1) {
        return (A)withNetworkResourceGroupName(new String(arg1));
    }

    public A withNewNetworkResourceGroupName(StringBuilder arg1) {
        return (A)withNetworkResourceGroupName(new String(arg1));
    }

    public A withNewNetworkResourceGroupName(StringBuffer arg1) {
        return (A)withNetworkResourceGroupName(new String(arg1));
    }

    public String getResourceGroupName() {
        return this.resourceGroupName;
    }

    public A withResourceGroupName(String resourceGroupName) {
        this.resourceGroupName=resourceGroupName; return (A) this;
    }

    public Boolean hasResourceGroupName() {
        return this.resourceGroupName != null;
    }

    public A withNewResourceGroupName(String arg1) {
        return (A)withResourceGroupName(new String(arg1));
    }

    public A withNewResourceGroupName(StringBuilder arg1) {
        return (A)withResourceGroupName(new String(arg1));
    }

    public A withNewResourceGroupName(StringBuffer arg1) {
        return (A)withResourceGroupName(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AzurePlatformStatusFluentImpl that = (AzurePlatformStatusFluentImpl) o;
        if (cloudName != null ? !cloudName.equals(that.cloudName) :that.cloudName != null) return false;
        if (networkResourceGroupName != null ? !networkResourceGroupName.equals(that.networkResourceGroupName) :that.networkResourceGroupName != null) return false;
        if (resourceGroupName != null ? !resourceGroupName.equals(that.resourceGroupName) :that.resourceGroupName != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(cloudName,  networkResourceGroupName,  resourceGroupName,  super.hashCode());
    }

}
