package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class LDAPIdentityProviderBuilder extends LDAPIdentityProviderFluentImpl<LDAPIdentityProviderBuilder> implements VisitableBuilder<LDAPIdentityProvider,LDAPIdentityProviderBuilder> {

    LDAPIdentityProviderFluent<?> fluent;
    Boolean validationEnabled;

    public LDAPIdentityProviderBuilder() {
        this(true);
    }

    public LDAPIdentityProviderBuilder(Boolean validationEnabled) {
        this(new LDAPIdentityProvider(), validationEnabled);
    }

    public LDAPIdentityProviderBuilder(LDAPIdentityProviderFluent<?> fluent) {
        this(fluent, true);
    }

    public LDAPIdentityProviderBuilder(LDAPIdentityProviderFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new LDAPIdentityProvider(), validationEnabled);
    }

    public LDAPIdentityProviderBuilder(LDAPIdentityProviderFluent<?> fluent,LDAPIdentityProvider instance) {
        this(fluent, instance, true);
    }

    public LDAPIdentityProviderBuilder(LDAPIdentityProviderFluent<?> fluent,LDAPIdentityProvider instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAttributes(instance.getAttributes()); 
        fluent.withBindDN(instance.getBindDN()); 
        fluent.withBindPassword(instance.getBindPassword()); 
        fluent.withCa(instance.getCa()); 
        fluent.withInsecure(instance.getInsecure()); 
        fluent.withUrl(instance.getUrl()); 
        this.validationEnabled = validationEnabled; 
    }

    public LDAPIdentityProviderBuilder(LDAPIdentityProvider instance) {
        this(instance,true);
    }

    public LDAPIdentityProviderBuilder(LDAPIdentityProvider instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAttributes(instance.getAttributes()); 
        this.withBindDN(instance.getBindDN()); 
        this.withBindPassword(instance.getBindPassword()); 
        this.withCa(instance.getCa()); 
        this.withInsecure(instance.getInsecure()); 
        this.withUrl(instance.getUrl()); 
        this.validationEnabled = validationEnabled; 
    }

    public LDAPIdentityProvider build() {
        LDAPIdentityProvider buildable = new LDAPIdentityProvider(fluent.getAttributes(),fluent.getBindDN(),fluent.getBindPassword(),fluent.getCa(),fluent.isInsecure(),fluent.getUrl());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        LDAPIdentityProviderBuilder that = (LDAPIdentityProviderBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
