package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServiceAccountPodSecurityPolicyReviewStatusBuilder extends ServiceAccountPodSecurityPolicyReviewStatusFluentImpl<ServiceAccountPodSecurityPolicyReviewStatusBuilder> implements VisitableBuilder<ServiceAccountPodSecurityPolicyReviewStatus,ServiceAccountPodSecurityPolicyReviewStatusBuilder> {

    ServiceAccountPodSecurityPolicyReviewStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceAccountPodSecurityPolicyReviewStatusBuilder() {
        this(true);
    }

    public ServiceAccountPodSecurityPolicyReviewStatusBuilder(Boolean validationEnabled) {
        this(new ServiceAccountPodSecurityPolicyReviewStatus(), validationEnabled);
    }

    public ServiceAccountPodSecurityPolicyReviewStatusBuilder(ServiceAccountPodSecurityPolicyReviewStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public ServiceAccountPodSecurityPolicyReviewStatusBuilder(ServiceAccountPodSecurityPolicyReviewStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ServiceAccountPodSecurityPolicyReviewStatus(), validationEnabled);
    }

    public ServiceAccountPodSecurityPolicyReviewStatusBuilder(ServiceAccountPodSecurityPolicyReviewStatusFluent<?> fluent,ServiceAccountPodSecurityPolicyReviewStatus instance) {
        this(fluent, instance, true);
    }

    public ServiceAccountPodSecurityPolicyReviewStatusBuilder(ServiceAccountPodSecurityPolicyReviewStatusFluent<?> fluent,ServiceAccountPodSecurityPolicyReviewStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAllowedBy(instance.getAllowedBy()); 
        fluent.withName(instance.getName()); 
        fluent.withReason(instance.getReason()); 
        fluent.withTemplate(instance.getTemplate()); 
        this.validationEnabled = validationEnabled; 
    }

    public ServiceAccountPodSecurityPolicyReviewStatusBuilder(ServiceAccountPodSecurityPolicyReviewStatus instance) {
        this(instance,true);
    }

    public ServiceAccountPodSecurityPolicyReviewStatusBuilder(ServiceAccountPodSecurityPolicyReviewStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAllowedBy(instance.getAllowedBy()); 
        this.withName(instance.getName()); 
        this.withReason(instance.getReason()); 
        this.withTemplate(instance.getTemplate()); 
        this.validationEnabled = validationEnabled; 
    }

    public ServiceAccountPodSecurityPolicyReviewStatus build() {
        ServiceAccountPodSecurityPolicyReviewStatus buildable = new ServiceAccountPodSecurityPolicyReviewStatus(fluent.getAllowedBy(),fluent.getName(),fluent.getReason(),fluent.getTemplate());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ServiceAccountPodSecurityPolicyReviewStatusBuilder that = (ServiceAccountPodSecurityPolicyReviewStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
