package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface ClusterNetworkFluent<A extends ClusterNetworkFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToClusterNetworks(int index,ClusterNetworkEntry item);
    public A setToClusterNetworks(int index,ClusterNetworkEntry item);
    public A addToClusterNetworks(ClusterNetworkEntry... items);
    public A addAllToClusterNetworks(Collection<ClusterNetworkEntry> items);
    public A removeFromClusterNetworks(ClusterNetworkEntry... items);
    public A removeAllFromClusterNetworks(Collection<ClusterNetworkEntry> items);
    public A removeMatchingFromClusterNetworks(Predicate<ClusterNetworkEntryBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildClusterNetworks instead.
 * @return The buildable object.
 */
@Deprecated public List<ClusterNetworkEntry> getClusterNetworks();
    public List<ClusterNetworkEntry> buildClusterNetworks();
    public ClusterNetworkEntry buildClusterNetwork(int index);
    public ClusterNetworkEntry buildFirstClusterNetwork();
    public ClusterNetworkEntry buildLastClusterNetwork();
    public ClusterNetworkEntry buildMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate);
    public Boolean hasMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate);
    public A withClusterNetworks(List<ClusterNetworkEntry> clusterNetworks);
    public A withClusterNetworks(ClusterNetworkEntry... clusterNetworks);
    public Boolean hasClusterNetworks();
    public A addNewClusterNetwork(String cidr,Integer hostSubnetLength);
    public ClusterNetworkFluent.ClusterNetworksNested<A> addNewClusterNetwork();
    public ClusterNetworkFluent.ClusterNetworksNested<A> addNewClusterNetworkLike(ClusterNetworkEntry item);
    public ClusterNetworkFluent.ClusterNetworksNested<A> setNewClusterNetworkLike(int index,ClusterNetworkEntry item);
    public ClusterNetworkFluent.ClusterNetworksNested<A> editClusterNetwork(int index);
    public ClusterNetworkFluent.ClusterNetworksNested<A> editFirstClusterNetwork();
    public ClusterNetworkFluent.ClusterNetworksNested<A> editLastClusterNetwork();
    public ClusterNetworkFluent.ClusterNetworksNested<A> editMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate);
    public Integer getHostsubnetlength();
    public A withHostsubnetlength(Integer hostsubnetlength);
    public Boolean hasHostsubnetlength();
    public A withNewHostsubnetlength(String arg1);
    public A withNewHostsubnetlength(int arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public ClusterNetworkFluent.MetadataNested<A> withNewMetadata();
    public ClusterNetworkFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ClusterNetworkFluent.MetadataNested<A> editMetadata();
    public ClusterNetworkFluent.MetadataNested<A> editOrNewMetadata();
    public ClusterNetworkFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public Integer getMtu();
    public A withMtu(Integer mtu);
    public Boolean hasMtu();
    public A withNewMtu(String arg1);
    public A withNewMtu(int arg1);
    public String getNetwork();
    public A withNetwork(String network);
    public Boolean hasNetwork();
    public A withNewNetwork(String arg1);
    public A withNewNetwork(StringBuilder arg1);
    public A withNewNetwork(StringBuffer arg1);
    public String getPluginName();
    public A withPluginName(String pluginName);
    public Boolean hasPluginName();
    public A withNewPluginName(String arg1);
    public A withNewPluginName(StringBuilder arg1);
    public A withNewPluginName(StringBuffer arg1);
    public String getServiceNetwork();
    public A withServiceNetwork(String serviceNetwork);
    public Boolean hasServiceNetwork();
    public A withNewServiceNetwork(String arg1);
    public A withNewServiceNetwork(StringBuilder arg1);
    public A withNewServiceNetwork(StringBuffer arg1);
    public Integer getVxlanPort();
    public A withVxlanPort(Integer vxlanPort);
    public Boolean hasVxlanPort();
    public A withNewVxlanPort(String arg1);
    public A withNewVxlanPort(int arg1);
    public interface ClusterNetworksNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterNetworkEntryFluent<ClusterNetworkFluent.ClusterNetworksNested<N>> {

            public N and();
            public N endClusterNetwork();    }


    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<ClusterNetworkFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


}
