package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ClusterResourceQuotaSpecBuilder extends ClusterResourceQuotaSpecFluentImpl<ClusterResourceQuotaSpecBuilder> implements VisitableBuilder<ClusterResourceQuotaSpec,ClusterResourceQuotaSpecBuilder> {

    ClusterResourceQuotaSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterResourceQuotaSpecBuilder() {
        this(true);
    }

    public ClusterResourceQuotaSpecBuilder(Boolean validationEnabled) {
        this(new ClusterResourceQuotaSpec(), validationEnabled);
    }

    public ClusterResourceQuotaSpecBuilder(ClusterResourceQuotaSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public ClusterResourceQuotaSpecBuilder(ClusterResourceQuotaSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ClusterResourceQuotaSpec(), validationEnabled);
    }

    public ClusterResourceQuotaSpecBuilder(ClusterResourceQuotaSpecFluent<?> fluent,ClusterResourceQuotaSpec instance) {
        this(fluent, instance, true);
    }

    public ClusterResourceQuotaSpecBuilder(ClusterResourceQuotaSpecFluent<?> fluent,ClusterResourceQuotaSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withQuota(instance.getQuota()); 
        fluent.withSelector(instance.getSelector()); 
        this.validationEnabled = validationEnabled; 
    }

    public ClusterResourceQuotaSpecBuilder(ClusterResourceQuotaSpec instance) {
        this(instance,true);
    }

    public ClusterResourceQuotaSpecBuilder(ClusterResourceQuotaSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withQuota(instance.getQuota()); 
        this.withSelector(instance.getSelector()); 
        this.validationEnabled = validationEnabled; 
    }

    public ClusterResourceQuotaSpec build() {
        ClusterResourceQuotaSpec buildable = new ClusterResourceQuotaSpec(fluent.getQuota(),fluent.getSelector());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ClusterResourceQuotaSpecBuilder that = (ClusterResourceQuotaSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
