package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ClusterVersionListBuilder extends ClusterVersionListFluentImpl<ClusterVersionListBuilder> implements VisitableBuilder<ClusterVersionList,ClusterVersionListBuilder> {

    ClusterVersionListFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterVersionListBuilder() {
        this(true);
    }

    public ClusterVersionListBuilder(Boolean validationEnabled) {
        this(new ClusterVersionList(), validationEnabled);
    }

    public ClusterVersionListBuilder(ClusterVersionListFluent<?> fluent) {
        this(fluent, true);
    }

    public ClusterVersionListBuilder(ClusterVersionListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ClusterVersionList(), validationEnabled);
    }

    public ClusterVersionListBuilder(ClusterVersionListFluent<?> fluent,ClusterVersionList instance) {
        this(fluent, instance, true);
    }

    public ClusterVersionListBuilder(ClusterVersionListFluent<?> fluent,ClusterVersionList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public ClusterVersionListBuilder(ClusterVersionList instance) {
        this(instance,true);
    }

    public ClusterVersionListBuilder(ClusterVersionList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public ClusterVersionList build() {
        ClusterVersionList buildable = new ClusterVersionList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ClusterVersionListBuilder that = (ClusterVersionListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
