package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;

public class ClusterVersionStatusFluentImpl<A extends ClusterVersionStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ClusterVersionStatusFluent<A> {

    private List<ReleaseBuilder> availableUpdates =  new ArrayList<ReleaseBuilder>();
    private List<ClusterOperatorStatusConditionBuilder> conditions =  new ArrayList<ClusterOperatorStatusConditionBuilder>();
    private ReleaseBuilder desired;
    private List<UpdateHistoryBuilder> history =  new ArrayList<UpdateHistoryBuilder>();
    private Long observedGeneration;
    private String versionHash;

    public ClusterVersionStatusFluentImpl() {
    }

    public ClusterVersionStatusFluentImpl(ClusterVersionStatus instance) {
        this.withAvailableUpdates(instance.getAvailableUpdates()); 
        this.withConditions(instance.getConditions()); 
        this.withDesired(instance.getDesired()); 
        this.withHistory(instance.getHistory()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withVersionHash(instance.getVersionHash()); 
    }

    public A addToAvailableUpdates(int index,Release item) {
        if (this.availableUpdates == null) {this.availableUpdates = new ArrayList<ReleaseBuilder>();}
        ReleaseBuilder builder = new ReleaseBuilder(item);_visitables.get("availableUpdates").add(index >= 0 ? index : _visitables.get("availableUpdates").size(), builder);this.availableUpdates.add(index >= 0 ? index : availableUpdates.size(), builder); return (A)this;
    }

    public A setToAvailableUpdates(int index,Release item) {
        if (this.availableUpdates == null) {this.availableUpdates = new ArrayList<ReleaseBuilder>();}
        ReleaseBuilder builder = new ReleaseBuilder(item);
        if (index < 0 || index >= _visitables.get("availableUpdates").size()) { _visitables.get("availableUpdates").add(builder); } else { _visitables.get("availableUpdates").set(index, builder);}
        if (index < 0 || index >= availableUpdates.size()) { availableUpdates.add(builder); } else { availableUpdates.set(index, builder);}
         return (A)this;
    }

    public A addToAvailableUpdates(Release... items) {
        if (this.availableUpdates == null) {this.availableUpdates = new ArrayList<ReleaseBuilder>();}
        for (Release item : items) {ReleaseBuilder builder = new ReleaseBuilder(item);_visitables.get("availableUpdates").add(builder);this.availableUpdates.add(builder);} return (A)this;
    }

    public A addAllToAvailableUpdates(Collection<Release> items) {
        if (this.availableUpdates == null) {this.availableUpdates = new ArrayList<ReleaseBuilder>();}
        for (Release item : items) {ReleaseBuilder builder = new ReleaseBuilder(item);_visitables.get("availableUpdates").add(builder);this.availableUpdates.add(builder);} return (A)this;
    }

    public A removeFromAvailableUpdates(Release... items) {
        for (Release item : items) {ReleaseBuilder builder = new ReleaseBuilder(item);_visitables.get("availableUpdates").remove(builder);if (this.availableUpdates != null) {this.availableUpdates.remove(builder);}} return (A)this;
    }

    public A removeAllFromAvailableUpdates(Collection<Release> items) {
        for (Release item : items) {ReleaseBuilder builder = new ReleaseBuilder(item);_visitables.get("availableUpdates").remove(builder);if (this.availableUpdates != null) {this.availableUpdates.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromAvailableUpdates(Predicate<ReleaseBuilder> predicate) {
        if (availableUpdates == null) return (A) this;
        final Iterator<ReleaseBuilder> each = availableUpdates.iterator();
        final List visitables = _visitables.get("availableUpdates");
        while (each.hasNext()) {
          ReleaseBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildAvailableUpdates instead.
 * @return The buildable object.
 */
@Deprecated public List<Release> getAvailableUpdates() {
        return build(availableUpdates);
    }

    public List<Release> buildAvailableUpdates() {
        return build(availableUpdates);
    }

    public Release buildAvailableUpdate(int index) {
        return this.availableUpdates.get(index).build();
    }

    public Release buildFirstAvailableUpdate() {
        return this.availableUpdates.get(0).build();
    }

    public Release buildLastAvailableUpdate() {
        return this.availableUpdates.get(availableUpdates.size() - 1).build();
    }

    public Release buildMatchingAvailableUpdate(Predicate<ReleaseBuilder> predicate) {
        for (ReleaseBuilder item: availableUpdates) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingAvailableUpdate(Predicate<ReleaseBuilder> predicate) {
        for (ReleaseBuilder item: availableUpdates) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withAvailableUpdates(List<Release> availableUpdates) {
        if (this.availableUpdates != null) { _visitables.get("availableUpdates").removeAll(this.availableUpdates);}
        if (availableUpdates != null) {this.availableUpdates = new ArrayList<ReleaseBuilder>(); for (Release item : availableUpdates){this.addToAvailableUpdates(item);}} else { this.availableUpdates = null;} return (A) this;
    }

    public A withAvailableUpdates(Release... availableUpdates) {
        if (this.availableUpdates != null) {this.availableUpdates.clear();}
        if (availableUpdates != null) {for (Release item :availableUpdates){ this.addToAvailableUpdates(item);}} return (A) this;
    }

    public Boolean hasAvailableUpdates() {
        return availableUpdates != null && !availableUpdates.isEmpty();
    }

    public ClusterVersionStatusFluent.AvailableUpdatesNested<A> addNewAvailableUpdate() {
        return new AvailableUpdatesNestedImpl();
    }

    public ClusterVersionStatusFluent.AvailableUpdatesNested<A> addNewAvailableUpdateLike(Release item) {
        return new AvailableUpdatesNestedImpl(-1, item);
    }

    public ClusterVersionStatusFluent.AvailableUpdatesNested<A> setNewAvailableUpdateLike(int index,Release item) {
        return new AvailableUpdatesNestedImpl(index, item);
    }

    public ClusterVersionStatusFluent.AvailableUpdatesNested<A> editAvailableUpdate(int index) {
        if (availableUpdates.size() <= index) throw new RuntimeException("Can't edit availableUpdates. Index exceeds size.");
        return setNewAvailableUpdateLike(index, buildAvailableUpdate(index));
    }

    public ClusterVersionStatusFluent.AvailableUpdatesNested<A> editFirstAvailableUpdate() {
        if (availableUpdates.size() == 0) throw new RuntimeException("Can't edit first availableUpdates. The list is empty.");
        return setNewAvailableUpdateLike(0, buildAvailableUpdate(0));
    }

    public ClusterVersionStatusFluent.AvailableUpdatesNested<A> editLastAvailableUpdate() {
        int index = availableUpdates.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last availableUpdates. The list is empty.");
        return setNewAvailableUpdateLike(index, buildAvailableUpdate(index));
    }

    public ClusterVersionStatusFluent.AvailableUpdatesNested<A> editMatchingAvailableUpdate(Predicate<ReleaseBuilder> predicate) {
        int index = -1;
        for (int i=0;i<availableUpdates.size();i++) { 
        if (predicate.test(availableUpdates.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching availableUpdates. No match found.");
        return setNewAvailableUpdateLike(index, buildAvailableUpdate(index));
    }

    public A addToConditions(int index,ClusterOperatorStatusCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<ClusterOperatorStatusConditionBuilder>();}
        ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,ClusterOperatorStatusCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<ClusterOperatorStatusConditionBuilder>();}
        ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);
        if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
        if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
         return (A)this;
    }

    public A addToConditions(ClusterOperatorStatusCondition... items) {
        if (this.conditions == null) {this.conditions = new ArrayList<ClusterOperatorStatusConditionBuilder>();}
        for (ClusterOperatorStatusCondition item : items) {ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<ClusterOperatorStatusCondition> items) {
        if (this.conditions == null) {this.conditions = new ArrayList<ClusterOperatorStatusConditionBuilder>();}
        for (ClusterOperatorStatusCondition item : items) {ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(ClusterOperatorStatusCondition... items) {
        for (ClusterOperatorStatusCondition item : items) {ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<ClusterOperatorStatusCondition> items) {
        for (ClusterOperatorStatusCondition item : items) {ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<ClusterOperatorStatusConditionBuilder> predicate) {
        if (conditions == null) return (A) this;
        final Iterator<ClusterOperatorStatusConditionBuilder> each = conditions.iterator();
        final List visitables = _visitables.get("conditions");
        while (each.hasNext()) {
          ClusterOperatorStatusConditionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<ClusterOperatorStatusCondition> getConditions() {
        return build(conditions);
    }

    public List<ClusterOperatorStatusCondition> buildConditions() {
        return build(conditions);
    }

    public ClusterOperatorStatusCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public ClusterOperatorStatusCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public ClusterOperatorStatusCondition buildLastCondition() {
        return this.conditions.get(conditions.size() - 1).build();
    }

    public ClusterOperatorStatusCondition buildMatchingCondition(Predicate<ClusterOperatorStatusConditionBuilder> predicate) {
        for (ClusterOperatorStatusConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(Predicate<ClusterOperatorStatusConditionBuilder> predicate) {
        for (ClusterOperatorStatusConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConditions(List<ClusterOperatorStatusCondition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new ArrayList<ClusterOperatorStatusConditionBuilder>(); for (ClusterOperatorStatusCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(ClusterOperatorStatusCondition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (ClusterOperatorStatusCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
        return (A)addToConditions(new ClusterOperatorStatusCondition(lastTransitionTime, message, reason, status, type));
    }

    public ClusterVersionStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    public ClusterVersionStatusFluent.ConditionsNested<A> addNewConditionLike(ClusterOperatorStatusCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    public ClusterVersionStatusFluent.ConditionsNested<A> setNewConditionLike(int index,ClusterOperatorStatusCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    public ClusterVersionStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public ClusterVersionStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
        return setNewConditionLike(0, buildCondition(0));
    }

    public ClusterVersionStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = conditions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public ClusterVersionStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ClusterOperatorStatusConditionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<conditions.size();i++) { 
        if (predicate.test(conditions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
        return setNewConditionLike(index, buildCondition(index));
    }

    
/**
 * This method has been deprecated, please use method buildDesired instead.
 * @return The buildable object.
 */
@Deprecated public Release getDesired() {
        return this.desired!=null?this.desired.build():null;
    }

    public Release buildDesired() {
        return this.desired!=null?this.desired.build():null;
    }

    public A withDesired(Release desired) {
        _visitables.get("desired").remove(this.desired);
        if (desired!=null){ this.desired= new ReleaseBuilder(desired); _visitables.get("desired").add(this.desired);} return (A) this;
    }

    public Boolean hasDesired() {
        return this.desired != null;
    }

    public ClusterVersionStatusFluent.DesiredNested<A> withNewDesired() {
        return new DesiredNestedImpl();
    }

    public ClusterVersionStatusFluent.DesiredNested<A> withNewDesiredLike(Release item) {
        return new DesiredNestedImpl(item);
    }

    public ClusterVersionStatusFluent.DesiredNested<A> editDesired() {
        return withNewDesiredLike(getDesired());
    }

    public ClusterVersionStatusFluent.DesiredNested<A> editOrNewDesired() {
        return withNewDesiredLike(getDesired() != null ? getDesired(): new ReleaseBuilder().build());
    }

    public ClusterVersionStatusFluent.DesiredNested<A> editOrNewDesiredLike(Release item) {
        return withNewDesiredLike(getDesired() != null ? getDesired(): item);
    }

    public A addToHistory(int index,UpdateHistory item) {
        if (this.history == null) {this.history = new ArrayList<UpdateHistoryBuilder>();}
        UpdateHistoryBuilder builder = new UpdateHistoryBuilder(item);_visitables.get("history").add(index >= 0 ? index : _visitables.get("history").size(), builder);this.history.add(index >= 0 ? index : history.size(), builder); return (A)this;
    }

    public A setToHistory(int index,UpdateHistory item) {
        if (this.history == null) {this.history = new ArrayList<UpdateHistoryBuilder>();}
        UpdateHistoryBuilder builder = new UpdateHistoryBuilder(item);
        if (index < 0 || index >= _visitables.get("history").size()) { _visitables.get("history").add(builder); } else { _visitables.get("history").set(index, builder);}
        if (index < 0 || index >= history.size()) { history.add(builder); } else { history.set(index, builder);}
         return (A)this;
    }

    public A addToHistory(UpdateHistory... items) {
        if (this.history == null) {this.history = new ArrayList<UpdateHistoryBuilder>();}
        for (UpdateHistory item : items) {UpdateHistoryBuilder builder = new UpdateHistoryBuilder(item);_visitables.get("history").add(builder);this.history.add(builder);} return (A)this;
    }

    public A addAllToHistory(Collection<UpdateHistory> items) {
        if (this.history == null) {this.history = new ArrayList<UpdateHistoryBuilder>();}
        for (UpdateHistory item : items) {UpdateHistoryBuilder builder = new UpdateHistoryBuilder(item);_visitables.get("history").add(builder);this.history.add(builder);} return (A)this;
    }

    public A removeFromHistory(UpdateHistory... items) {
        for (UpdateHistory item : items) {UpdateHistoryBuilder builder = new UpdateHistoryBuilder(item);_visitables.get("history").remove(builder);if (this.history != null) {this.history.remove(builder);}} return (A)this;
    }

    public A removeAllFromHistory(Collection<UpdateHistory> items) {
        for (UpdateHistory item : items) {UpdateHistoryBuilder builder = new UpdateHistoryBuilder(item);_visitables.get("history").remove(builder);if (this.history != null) {this.history.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromHistory(Predicate<UpdateHistoryBuilder> predicate) {
        if (history == null) return (A) this;
        final Iterator<UpdateHistoryBuilder> each = history.iterator();
        final List visitables = _visitables.get("history");
        while (each.hasNext()) {
          UpdateHistoryBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildHistory instead.
 * @return The buildable object.
 */
@Deprecated public List<UpdateHistory> getHistory() {
        return build(history);
    }

    public List<UpdateHistory> buildHistory() {
        return build(history);
    }

    public UpdateHistory buildHistory(int index) {
        return this.history.get(index).build();
    }

    public UpdateHistory buildFirstHistory() {
        return this.history.get(0).build();
    }

    public UpdateHistory buildLastHistory() {
        return this.history.get(history.size() - 1).build();
    }

    public UpdateHistory buildMatchingHistory(Predicate<UpdateHistoryBuilder> predicate) {
        for (UpdateHistoryBuilder item: history) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingHistory(Predicate<UpdateHistoryBuilder> predicate) {
        for (UpdateHistoryBuilder item: history) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withHistory(List<UpdateHistory> history) {
        if (this.history != null) { _visitables.get("history").removeAll(this.history);}
        if (history != null) {this.history = new ArrayList<UpdateHistoryBuilder>(); for (UpdateHistory item : history){this.addToHistory(item);}} else { this.history = null;} return (A) this;
    }

    public A withHistory(UpdateHistory... history) {
        if (this.history != null) {this.history.clear();}
        if (history != null) {for (UpdateHistory item :history){ this.addToHistory(item);}} return (A) this;
    }

    public Boolean hasHistory() {
        return history != null && !history.isEmpty();
    }

    public ClusterVersionStatusFluent.HistoryNested<A> addNewHistory() {
        return new HistoryNestedImpl();
    }

    public ClusterVersionStatusFluent.HistoryNested<A> addNewHistoryLike(UpdateHistory item) {
        return new HistoryNestedImpl(-1, item);
    }

    public ClusterVersionStatusFluent.HistoryNested<A> setNewHistoryLike(int index,UpdateHistory item) {
        return new HistoryNestedImpl(index, item);
    }

    public ClusterVersionStatusFluent.HistoryNested<A> editHistory(int index) {
        if (history.size() <= index) throw new RuntimeException("Can't edit history. Index exceeds size.");
        return setNewHistoryLike(index, buildHistory(index));
    }

    public ClusterVersionStatusFluent.HistoryNested<A> editFirstHistory() {
        if (history.size() == 0) throw new RuntimeException("Can't edit first history. The list is empty.");
        return setNewHistoryLike(0, buildHistory(0));
    }

    public ClusterVersionStatusFluent.HistoryNested<A> editLastHistory() {
        int index = history.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last history. The list is empty.");
        return setNewHistoryLike(index, buildHistory(index));
    }

    public ClusterVersionStatusFluent.HistoryNested<A> editMatchingHistory(Predicate<UpdateHistoryBuilder> predicate) {
        int index = -1;
        for (int i=0;i<history.size();i++) { 
        if (predicate.test(history.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching history. No match found.");
        return setNewHistoryLike(index, buildHistory(index));
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration=observedGeneration; return (A) this;
    }

    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public A withNewObservedGeneration(String arg1) {
        return (A)withObservedGeneration(new Long(arg1));
    }

    public A withNewObservedGeneration(long arg1) {
        return (A)withObservedGeneration(new Long(arg1));
    }

    public String getVersionHash() {
        return this.versionHash;
    }

    public A withVersionHash(String versionHash) {
        this.versionHash=versionHash; return (A) this;
    }

    public Boolean hasVersionHash() {
        return this.versionHash != null;
    }

    public A withNewVersionHash(String arg1) {
        return (A)withVersionHash(new String(arg1));
    }

    public A withNewVersionHash(StringBuilder arg1) {
        return (A)withVersionHash(new String(arg1));
    }

    public A withNewVersionHash(StringBuffer arg1) {
        return (A)withVersionHash(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ClusterVersionStatusFluentImpl that = (ClusterVersionStatusFluentImpl) o;
        if (availableUpdates != null ? !availableUpdates.equals(that.availableUpdates) :that.availableUpdates != null) return false;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        if (desired != null ? !desired.equals(that.desired) :that.desired != null) return false;
        if (history != null ? !history.equals(that.history) :that.history != null) return false;
        if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
        if (versionHash != null ? !versionHash.equals(that.versionHash) :that.versionHash != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(availableUpdates,  conditions,  desired,  history,  observedGeneration,  versionHash,  super.hashCode());
    }

    public class AvailableUpdatesNestedImpl<N> extends ReleaseFluentImpl<ClusterVersionStatusFluent.AvailableUpdatesNested<N>> implements ClusterVersionStatusFluent.AvailableUpdatesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ReleaseBuilder builder;
        private final int index;

            AvailableUpdatesNestedImpl(int index,Release item) {
                this.index = index;
                this.builder = new ReleaseBuilder(this, item);
                        
            }

            AvailableUpdatesNestedImpl() {
                this.index = -1;
                this.builder = new ReleaseBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterVersionStatusFluentImpl.this.setToAvailableUpdates(index,builder.build());
            }

            public N endAvailableUpdate() {
                return and();
            }
    }


    public class ConditionsNestedImpl<N> extends ClusterOperatorStatusConditionFluentImpl<ClusterVersionStatusFluent.ConditionsNested<N>> implements ClusterVersionStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ClusterOperatorStatusConditionBuilder builder;
        private final int index;

            ConditionsNestedImpl(int index,ClusterOperatorStatusCondition item) {
                this.index = index;
                this.builder = new ClusterOperatorStatusConditionBuilder(this, item);
                        
            }

            ConditionsNestedImpl() {
                this.index = -1;
                this.builder = new ClusterOperatorStatusConditionBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterVersionStatusFluentImpl.this.setToConditions(index,builder.build());
            }

            public N endCondition() {
                return and();
            }
    }


    public class DesiredNestedImpl<N> extends ReleaseFluentImpl<ClusterVersionStatusFluent.DesiredNested<N>> implements ClusterVersionStatusFluent.DesiredNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ReleaseBuilder builder;

            DesiredNestedImpl(Release item) {
                this.builder = new ReleaseBuilder(this, item);
                        
            }

            DesiredNestedImpl() {
                this.builder = new ReleaseBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterVersionStatusFluentImpl.this.withDesired(builder.build());
            }

            public N endDesired() {
                return and();
            }
    }


    public class HistoryNestedImpl<N> extends UpdateHistoryFluentImpl<ClusterVersionStatusFluent.HistoryNested<N>> implements ClusterVersionStatusFluent.HistoryNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final UpdateHistoryBuilder builder;
        private final int index;

            HistoryNestedImpl(int index,UpdateHistory item) {
                this.index = index;
                this.builder = new UpdateHistoryBuilder(this, item);
                        
            }

            HistoryNestedImpl() {
                this.index = -1;
                this.builder = new UpdateHistoryBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterVersionStatusFluentImpl.this.setToHistory(index,builder.build());
            }

            public N endHistory() {
                return and();
            }
    }


}
