package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class FeatureGateListBuilder extends FeatureGateListFluentImpl<FeatureGateListBuilder> implements VisitableBuilder<FeatureGateList,FeatureGateListBuilder> {

    FeatureGateListFluent<?> fluent;
    Boolean validationEnabled;

    public FeatureGateListBuilder() {
        this(true);
    }

    public FeatureGateListBuilder(Boolean validationEnabled) {
        this(new FeatureGateList(), validationEnabled);
    }

    public FeatureGateListBuilder(FeatureGateListFluent<?> fluent) {
        this(fluent, true);
    }

    public FeatureGateListBuilder(FeatureGateListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new FeatureGateList(), validationEnabled);
    }

    public FeatureGateListBuilder(FeatureGateListFluent<?> fluent,FeatureGateList instance) {
        this(fluent, instance, true);
    }

    public FeatureGateListBuilder(FeatureGateListFluent<?> fluent,FeatureGateList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public FeatureGateListBuilder(FeatureGateList instance) {
        this(instance,true);
    }

    public FeatureGateListBuilder(FeatureGateList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public FeatureGateList build() {
        FeatureGateList buildable = new FeatureGateList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        FeatureGateListBuilder that = (FeatureGateListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
