package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class SubjectRulesReviewStatusFluentImpl<A extends SubjectRulesReviewStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SubjectRulesReviewStatusFluent<A> {

    private String evaluationError;
    private List<PolicyRuleBuilder> rules =  new ArrayList<PolicyRuleBuilder>();

    public SubjectRulesReviewStatusFluentImpl() {
    }

    public SubjectRulesReviewStatusFluentImpl(SubjectRulesReviewStatus instance) {
        this.withEvaluationError(instance.getEvaluationError()); 
        this.withRules(instance.getRules()); 
    }

    public String getEvaluationError() {
        return this.evaluationError;
    }

    public A withEvaluationError(String evaluationError) {
        this.evaluationError=evaluationError; return (A) this;
    }

    public Boolean hasEvaluationError() {
        return this.evaluationError != null;
    }

    public A withNewEvaluationError(String arg1) {
        return (A)withEvaluationError(new String(arg1));
    }

    public A withNewEvaluationError(StringBuilder arg1) {
        return (A)withEvaluationError(new String(arg1));
    }

    public A withNewEvaluationError(StringBuffer arg1) {
        return (A)withEvaluationError(new String(arg1));
    }

    public A addToRules(int index,PolicyRule item) {
        if (this.rules == null) {this.rules = new ArrayList<PolicyRuleBuilder>();}
        PolicyRuleBuilder builder = new PolicyRuleBuilder(item);_visitables.get("rules").add(index >= 0 ? index : _visitables.get("rules").size(), builder);this.rules.add(index >= 0 ? index : rules.size(), builder); return (A)this;
    }

    public A setToRules(int index,PolicyRule item) {
        if (this.rules == null) {this.rules = new ArrayList<PolicyRuleBuilder>();}
        PolicyRuleBuilder builder = new PolicyRuleBuilder(item);
        if (index < 0 || index >= _visitables.get("rules").size()) { _visitables.get("rules").add(builder); } else { _visitables.get("rules").set(index, builder);}
        if (index < 0 || index >= rules.size()) { rules.add(builder); } else { rules.set(index, builder);}
         return (A)this;
    }

    public A addToRules(PolicyRule... items) {
        if (this.rules == null) {this.rules = new ArrayList<PolicyRuleBuilder>();}
        for (PolicyRule item : items) {PolicyRuleBuilder builder = new PolicyRuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
    }

    public A addAllToRules(Collection<PolicyRule> items) {
        if (this.rules == null) {this.rules = new ArrayList<PolicyRuleBuilder>();}
        for (PolicyRule item : items) {PolicyRuleBuilder builder = new PolicyRuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
    }

    public A removeFromRules(PolicyRule... items) {
        for (PolicyRule item : items) {PolicyRuleBuilder builder = new PolicyRuleBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
    }

    public A removeAllFromRules(Collection<PolicyRule> items) {
        for (PolicyRule item : items) {PolicyRuleBuilder builder = new PolicyRuleBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromRules(Predicate<PolicyRuleBuilder> predicate) {
        if (rules == null) return (A) this;
        final Iterator<PolicyRuleBuilder> each = rules.iterator();
        final List visitables = _visitables.get("rules");
        while (each.hasNext()) {
          PolicyRuleBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRules instead.
 * @return The buildable object.
 */
@Deprecated public List<PolicyRule> getRules() {
        return build(rules);
    }

    public List<PolicyRule> buildRules() {
        return build(rules);
    }

    public PolicyRule buildRule(int index) {
        return this.rules.get(index).build();
    }

    public PolicyRule buildFirstRule() {
        return this.rules.get(0).build();
    }

    public PolicyRule buildLastRule() {
        return this.rules.get(rules.size() - 1).build();
    }

    public PolicyRule buildMatchingRule(Predicate<PolicyRuleBuilder> predicate) {
        for (PolicyRuleBuilder item: rules) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingRule(Predicate<PolicyRuleBuilder> predicate) {
        for (PolicyRuleBuilder item: rules) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withRules(List<PolicyRule> rules) {
        if (this.rules != null) { _visitables.get("rules").removeAll(this.rules);}
        if (rules != null) {this.rules = new ArrayList<PolicyRuleBuilder>(); for (PolicyRule item : rules){this.addToRules(item);}} else { this.rules = null;} return (A) this;
    }

    public A withRules(PolicyRule... rules) {
        if (this.rules != null) {this.rules.clear();}
        if (rules != null) {for (PolicyRule item :rules){ this.addToRules(item);}} return (A) this;
    }

    public Boolean hasRules() {
        return rules != null && !rules.isEmpty();
    }

    public SubjectRulesReviewStatusFluent.RulesNested<A> addNewRule() {
        return new RulesNestedImpl();
    }

    public SubjectRulesReviewStatusFluent.RulesNested<A> addNewRuleLike(PolicyRule item) {
        return new RulesNestedImpl(-1, item);
    }

    public SubjectRulesReviewStatusFluent.RulesNested<A> setNewRuleLike(int index,PolicyRule item) {
        return new RulesNestedImpl(index, item);
    }

    public SubjectRulesReviewStatusFluent.RulesNested<A> editRule(int index) {
        if (rules.size() <= index) throw new RuntimeException("Can't edit rules. Index exceeds size.");
        return setNewRuleLike(index, buildRule(index));
    }

    public SubjectRulesReviewStatusFluent.RulesNested<A> editFirstRule() {
        if (rules.size() == 0) throw new RuntimeException("Can't edit first rules. The list is empty.");
        return setNewRuleLike(0, buildRule(0));
    }

    public SubjectRulesReviewStatusFluent.RulesNested<A> editLastRule() {
        int index = rules.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last rules. The list is empty.");
        return setNewRuleLike(index, buildRule(index));
    }

    public SubjectRulesReviewStatusFluent.RulesNested<A> editMatchingRule(Predicate<PolicyRuleBuilder> predicate) {
        int index = -1;
        for (int i=0;i<rules.size();i++) { 
        if (predicate.test(rules.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching rules. No match found.");
        return setNewRuleLike(index, buildRule(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SubjectRulesReviewStatusFluentImpl that = (SubjectRulesReviewStatusFluentImpl) o;
        if (evaluationError != null ? !evaluationError.equals(that.evaluationError) :that.evaluationError != null) return false;
        if (rules != null ? !rules.equals(that.rules) :that.rules != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(evaluationError,  rules,  super.hashCode());
    }

    public class RulesNestedImpl<N> extends PolicyRuleFluentImpl<SubjectRulesReviewStatusFluent.RulesNested<N>> implements SubjectRulesReviewStatusFluent.RulesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PolicyRuleBuilder builder;
        private final int index;

            RulesNestedImpl(int index,PolicyRule item) {
                this.index = index;
                this.builder = new PolicyRuleBuilder(this, item);
                        
            }

            RulesNestedImpl() {
                this.index = -1;
                this.builder = new PolicyRuleBuilder(this);
                        
            }

            public N and() {
                return (N) SubjectRulesReviewStatusFluentImpl.this.setToRules(index,builder.build());
            }

            public N endRule() {
                return and();
            }
    }


}
