/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.PowerVSPlatformSpec;
import io.fabric8.openshift.api.model.PowerVSPlatformSpecFluent;
import io.fabric8.openshift.api.model.PowerVSPlatformSpecFluentImpl;
import java.util.Objects;

public class PowerVSPlatformSpecBuilder
extends PowerVSPlatformSpecFluentImpl<PowerVSPlatformSpecBuilder>
implements VisitableBuilder<PowerVSPlatformSpec, PowerVSPlatformSpecBuilder> {
    PowerVSPlatformSpecFluent<?> fluent;
    Boolean validationEnabled;

    public PowerVSPlatformSpecBuilder() {
        this(false);
    }

    public PowerVSPlatformSpecBuilder(Boolean validationEnabled) {
        this(new PowerVSPlatformSpec(), validationEnabled);
    }

    public PowerVSPlatformSpecBuilder(PowerVSPlatformSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public PowerVSPlatformSpecBuilder(PowerVSPlatformSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new PowerVSPlatformSpec(), validationEnabled);
    }

    public PowerVSPlatformSpecBuilder(PowerVSPlatformSpecFluent<?> fluent, PowerVSPlatformSpec instance) {
        this(fluent, instance, false);
    }

    public PowerVSPlatformSpecBuilder(PowerVSPlatformSpecFluent<?> fluent, PowerVSPlatformSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withServiceEndpoints(instance.getServiceEndpoints());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public PowerVSPlatformSpecBuilder(PowerVSPlatformSpec instance) {
        this(instance, (Boolean)false);
    }

    public PowerVSPlatformSpecBuilder(PowerVSPlatformSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withServiceEndpoints(instance.getServiceEndpoints());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public PowerVSPlatformSpec build() {
        PowerVSPlatformSpec buildable = new PowerVSPlatformSpec(this.fluent.getServiceEndpoints());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PowerVSPlatformSpecBuilder that = (PowerVSPlatformSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

