package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ClusterNetworkEntryBuilder extends io.fabric8.openshift.api.model.ClusterNetworkEntryFluentImpl<io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.ClusterNetworkEntry,io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder>{
  public ClusterNetworkEntryBuilder() {
    this(false);
  }
  public ClusterNetworkEntryBuilder(java.lang.Boolean validationEnabled) {
    this(new ClusterNetworkEntry(), validationEnabled);
  }
  public ClusterNetworkEntryBuilder(io.fabric8.openshift.api.model.ClusterNetworkEntryFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterNetworkEntryBuilder(io.fabric8.openshift.api.model.ClusterNetworkEntryFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ClusterNetworkEntry(), validationEnabled);
  }
  public ClusterNetworkEntryBuilder(io.fabric8.openshift.api.model.ClusterNetworkEntryFluent<?> fluent,io.fabric8.openshift.api.model.ClusterNetworkEntry instance) {
    this(fluent, instance, false);
  }
  public ClusterNetworkEntryBuilder(io.fabric8.openshift.api.model.ClusterNetworkEntryFluent<?> fluent,io.fabric8.openshift.api.model.ClusterNetworkEntry instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCidr(instance.getCidr()); 
    fluent.withHostSubnetLength(instance.getHostSubnetLength()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterNetworkEntryBuilder(io.fabric8.openshift.api.model.ClusterNetworkEntry instance) {
    this(instance,false);
  }
  public ClusterNetworkEntryBuilder(io.fabric8.openshift.api.model.ClusterNetworkEntry instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCidr(instance.getCidr()); 
    this.withHostSubnetLength(instance.getHostSubnetLength()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ClusterNetworkEntryFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ClusterNetworkEntry build() {
    ClusterNetworkEntry buildable = new ClusterNetworkEntry(fluent.getCidr(),fluent.getHostSubnetLength());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterNetworkEntryBuilder that = (ClusterNetworkEntryBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}