package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.Condition;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public class ConditionalUpdateFluentImpl<A extends io.fabric8.openshift.api.model.ConditionalUpdateFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.ConditionalUpdateFluent<A>{
  public ConditionalUpdateFluentImpl() {
  }
  public ConditionalUpdateFluentImpl(io.fabric8.openshift.api.model.ConditionalUpdate instance) {
    this.withConditions(instance.getConditions()); 
    this.withRelease(instance.getRelease()); 
    this.withRisks(instance.getRisks()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.util.List<io.fabric8.kubernetes.api.model.Condition> conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();
  private io.fabric8.openshift.api.model.ReleaseBuilder release;
  private java.util.List<io.fabric8.openshift.api.model.ConditionalUpdateRiskBuilder> risks =  new java.util.ArrayList<io.fabric8.openshift.api.model.ConditionalUpdateRiskBuilder>();
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public A addToConditions(java.lang.Integer index,io.fabric8.kubernetes.api.model.Condition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();}
    this.conditions.add(index, item);
    return (A)this;
  }
  public A setToConditions(java.lang.Integer index,io.fabric8.kubernetes.api.model.Condition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();}
    this.conditions.set(index, item); return (A)this;
  }
  public A addToConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();}
    for (io.fabric8.kubernetes.api.model.Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A addAllToConditions(java.util.Collection<io.fabric8.kubernetes.api.model.Condition> items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();}
    for (io.fabric8.kubernetes.api.model.Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    for (io.fabric8.kubernetes.api.model.Condition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
  }
  public A removeAllFromConditions(java.util.Collection<io.fabric8.kubernetes.api.model.Condition> items) {
    for (io.fabric8.kubernetes.api.model.Condition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.Condition> getConditions() {
    return this.conditions;
  }
  public io.fabric8.kubernetes.api.model.Condition getCondition(java.lang.Integer index) {
    return this.conditions.get(index);
  }
  public io.fabric8.kubernetes.api.model.Condition getFirstCondition() {
    return this.conditions.get(0);
  }
  public io.fabric8.kubernetes.api.model.Condition getLastCondition() {
    return this.conditions.get(conditions.size() - 1);
  }
  public io.fabric8.kubernetes.api.model.Condition getMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.Condition> predicate) {
    for (io.fabric8.kubernetes.api.model.Condition item: conditions) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.Condition> predicate) {
    for (io.fabric8.kubernetes.api.model.Condition item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(java.util.List<io.fabric8.kubernetes.api.model.Condition> conditions) {
    if (conditions != null) {this.conditions = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.kubernetes.api.model.Condition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (io.fabric8.kubernetes.api.model.Condition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public java.lang.Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildRelease instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.Release getRelease() {
    return this.release!=null?this.release.build():null;
  }
  public io.fabric8.openshift.api.model.Release buildRelease() {
    return this.release!=null?this.release.build():null;
  }
  public A withRelease(io.fabric8.openshift.api.model.Release release) {
    _visitables.get("release").remove(this.release);
    if (release!=null){ this.release= new io.fabric8.openshift.api.model.ReleaseBuilder(release); _visitables.get("release").add(this.release);} return (A) this;
  }
  public java.lang.Boolean hasRelease() {
    return this.release != null;
  }
  public io.fabric8.openshift.api.model.ConditionalUpdateFluent.ReleaseNested<A> withNewRelease() {
    return new io.fabric8.openshift.api.model.ConditionalUpdateFluentImpl.ReleaseNestedImpl();
  }
  public io.fabric8.openshift.api.model.ConditionalUpdateFluent.ReleaseNested<A> withNewReleaseLike(io.fabric8.openshift.api.model.Release item) {
    return new io.fabric8.openshift.api.model.ConditionalUpdateFluentImpl.ReleaseNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.ConditionalUpdateFluent.ReleaseNested<A> editRelease() {
    return withNewReleaseLike(getRelease());
  }
  public io.fabric8.openshift.api.model.ConditionalUpdateFluent.ReleaseNested<A> editOrNewRelease() {
    return withNewReleaseLike(getRelease() != null ? getRelease(): new io.fabric8.openshift.api.model.ReleaseBuilder().build());
  }
  public io.fabric8.openshift.api.model.ConditionalUpdateFluent.ReleaseNested<A> editOrNewReleaseLike(io.fabric8.openshift.api.model.Release item) {
    return withNewReleaseLike(getRelease() != null ? getRelease(): item);
  }
  public A addToRisks(java.lang.Integer index,io.fabric8.openshift.api.model.ConditionalUpdateRisk item) {
    if (this.risks == null) {this.risks = new java.util.ArrayList<io.fabric8.openshift.api.model.ConditionalUpdateRiskBuilder>();}
    io.fabric8.openshift.api.model.ConditionalUpdateRiskBuilder builder = new io.fabric8.openshift.api.model.ConditionalUpdateRiskBuilder(item);_visitables.get("risks").add(index >= 0 ? index : _visitables.get("risks").size(), builder);this.risks.add(index >= 0 ? index : risks.size(), builder); return (A)this;
  }
  public A setToRisks(java.lang.Integer index,io.fabric8.openshift.api.model.ConditionalUpdateRisk item) {
    if (this.risks == null) {this.risks = new java.util.ArrayList<io.fabric8.openshift.api.model.ConditionalUpdateRiskBuilder>();}
    io.fabric8.openshift.api.model.ConditionalUpdateRiskBuilder builder = new io.fabric8.openshift.api.model.ConditionalUpdateRiskBuilder(item);
    if (index < 0 || index >= _visitables.get("risks").size()) { _visitables.get("risks").add(builder); } else { _visitables.get("risks").set(index, builder);}
    if (index < 0 || index >= risks.size()) { risks.add(builder); } else { risks.set(index, builder);}
     return (A)this;
  }
  public A addToRisks(io.fabric8.openshift.api.model.ConditionalUpdateRisk... items) {
    if (this.risks == null) {this.risks = new java.util.ArrayList<io.fabric8.openshift.api.model.ConditionalUpdateRiskBuilder>();}
    for (io.fabric8.openshift.api.model.ConditionalUpdateRisk item : items) {io.fabric8.openshift.api.model.ConditionalUpdateRiskBuilder builder = new io.fabric8.openshift.api.model.ConditionalUpdateRiskBuilder(item);_visitables.get("risks").add(builder);this.risks.add(builder);} return (A)this;
  }
  public A addAllToRisks(java.util.Collection<io.fabric8.openshift.api.model.ConditionalUpdateRisk> items) {
    if (this.risks == null) {this.risks = new java.util.ArrayList<io.fabric8.openshift.api.model.ConditionalUpdateRiskBuilder>();}
    for (io.fabric8.openshift.api.model.ConditionalUpdateRisk item : items) {io.fabric8.openshift.api.model.ConditionalUpdateRiskBuilder builder = new io.fabric8.openshift.api.model.ConditionalUpdateRiskBuilder(item);_visitables.get("risks").add(builder);this.risks.add(builder);} return (A)this;
  }
  public A removeFromRisks(io.fabric8.openshift.api.model.ConditionalUpdateRisk... items) {
    for (io.fabric8.openshift.api.model.ConditionalUpdateRisk item : items) {io.fabric8.openshift.api.model.ConditionalUpdateRiskBuilder builder = new io.fabric8.openshift.api.model.ConditionalUpdateRiskBuilder(item);_visitables.get("risks").remove(builder);if (this.risks != null) {this.risks.remove(builder);}} return (A)this;
  }
  public A removeAllFromRisks(java.util.Collection<io.fabric8.openshift.api.model.ConditionalUpdateRisk> items) {
    for (io.fabric8.openshift.api.model.ConditionalUpdateRisk item : items) {io.fabric8.openshift.api.model.ConditionalUpdateRiskBuilder builder = new io.fabric8.openshift.api.model.ConditionalUpdateRiskBuilder(item);_visitables.get("risks").remove(builder);if (this.risks != null) {this.risks.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRisks(java.util.function.Predicate<io.fabric8.openshift.api.model.ConditionalUpdateRiskBuilder> predicate) {
    if (risks == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.ConditionalUpdateRiskBuilder> each = risks.iterator();
    final List visitables = _visitables.get("risks");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.ConditionalUpdateRiskBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildRisks instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.ConditionalUpdateRisk> getRisks() {
    return build(risks);
  }
  public java.util.List<io.fabric8.openshift.api.model.ConditionalUpdateRisk> buildRisks() {
    return build(risks);
  }
  public io.fabric8.openshift.api.model.ConditionalUpdateRisk buildRisk(java.lang.Integer index) {
    return this.risks.get(index).build();
  }
  public io.fabric8.openshift.api.model.ConditionalUpdateRisk buildFirstRisk() {
    return this.risks.get(0).build();
  }
  public io.fabric8.openshift.api.model.ConditionalUpdateRisk buildLastRisk() {
    return this.risks.get(risks.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.ConditionalUpdateRisk buildMatchingRisk(java.util.function.Predicate<io.fabric8.openshift.api.model.ConditionalUpdateRiskBuilder> predicate) {
    for (io.fabric8.openshift.api.model.ConditionalUpdateRiskBuilder item: risks) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingRisk(java.util.function.Predicate<io.fabric8.openshift.api.model.ConditionalUpdateRiskBuilder> predicate) {
    for (io.fabric8.openshift.api.model.ConditionalUpdateRiskBuilder item: risks) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRisks(java.util.List<io.fabric8.openshift.api.model.ConditionalUpdateRisk> risks) {
    if (this.risks != null) { _visitables.get("risks").removeAll(this.risks);}
    if (risks != null) {this.risks = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.ConditionalUpdateRisk item : risks){this.addToRisks(item);}} else { this.risks = null;} return (A) this;
  }
  public A withRisks(io.fabric8.openshift.api.model.ConditionalUpdateRisk... risks) {
    if (this.risks != null) {this.risks.clear();}
    if (risks != null) {for (io.fabric8.openshift.api.model.ConditionalUpdateRisk item :risks){ this.addToRisks(item);}} return (A) this;
  }
  public java.lang.Boolean hasRisks() {
    return risks != null && !risks.isEmpty();
  }
  public io.fabric8.openshift.api.model.ConditionalUpdateFluent.RisksNested<A> addNewRisk() {
    return new io.fabric8.openshift.api.model.ConditionalUpdateFluentImpl.RisksNestedImpl();
  }
  public io.fabric8.openshift.api.model.ConditionalUpdateFluent.RisksNested<A> addNewRiskLike(io.fabric8.openshift.api.model.ConditionalUpdateRisk item) {
    return new io.fabric8.openshift.api.model.ConditionalUpdateFluentImpl.RisksNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.ConditionalUpdateFluent.RisksNested<A> setNewRiskLike(java.lang.Integer index,io.fabric8.openshift.api.model.ConditionalUpdateRisk item) {
    return new io.fabric8.openshift.api.model.ConditionalUpdateFluentImpl.RisksNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.ConditionalUpdateFluent.RisksNested<A> editRisk(java.lang.Integer index) {
    if (risks.size() <= index) throw new RuntimeException("Can't edit risks. Index exceeds size.");
    return setNewRiskLike(index, buildRisk(index));
  }
  public io.fabric8.openshift.api.model.ConditionalUpdateFluent.RisksNested<A> editFirstRisk() {
    if (risks.size() == 0) throw new RuntimeException("Can't edit first risks. The list is empty.");
    return setNewRiskLike(0, buildRisk(0));
  }
  public io.fabric8.openshift.api.model.ConditionalUpdateFluent.RisksNested<A> editLastRisk() {
    int index = risks.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last risks. The list is empty.");
    return setNewRiskLike(index, buildRisk(index));
  }
  public io.fabric8.openshift.api.model.ConditionalUpdateFluent.RisksNested<A> editMatchingRisk(java.util.function.Predicate<io.fabric8.openshift.api.model.ConditionalUpdateRiskBuilder> predicate) {
    int index = -1;
    for (int i=0;i<risks.size();i++) { 
    if (predicate.test(risks.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching risks. No match found.");
    return setNewRiskLike(index, buildRisk(index));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ConditionalUpdateFluentImpl that = (ConditionalUpdateFluentImpl) o;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (release != null ? !release.equals(that.release) :that.release != null) return false;
    if (risks != null ? !risks.equals(that.risks) :that.risks != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  release,  risks,  additionalProperties,  super.hashCode());
  }
  public class ReleaseNestedImpl<N> extends io.fabric8.openshift.api.model.ReleaseFluentImpl<io.fabric8.openshift.api.model.ConditionalUpdateFluent.ReleaseNested<N>> implements io.fabric8.openshift.api.model.ConditionalUpdateFluent.ReleaseNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ReleaseNestedImpl(io.fabric8.openshift.api.model.Release item) {
      this.builder = new io.fabric8.openshift.api.model.ReleaseBuilder(this, item);
    }
    ReleaseNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ReleaseBuilder(this);
    }
    io.fabric8.openshift.api.model.ReleaseBuilder builder;
    public N and() {
      return (N) ConditionalUpdateFluentImpl.this.withRelease(builder.build());
    }
    public N endRelease() {
      return and();
    }
    
  }
  public class RisksNestedImpl<N> extends io.fabric8.openshift.api.model.ConditionalUpdateRiskFluentImpl<io.fabric8.openshift.api.model.ConditionalUpdateFluent.RisksNested<N>> implements io.fabric8.openshift.api.model.ConditionalUpdateFluent.RisksNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RisksNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.ConditionalUpdateRisk item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.ConditionalUpdateRiskBuilder(this, item);
    }
    RisksNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.ConditionalUpdateRiskBuilder(this);
    }
    io.fabric8.openshift.api.model.ConditionalUpdateRiskBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ConditionalUpdateFluentImpl.this.setToRisks(index,builder.build());
    }
    public N endRisk() {
      return and();
    }
    
  }
  
}