package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class HostSubnetBuilder extends io.fabric8.openshift.api.model.HostSubnetFluentImpl<io.fabric8.openshift.api.model.HostSubnetBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.HostSubnet,io.fabric8.openshift.api.model.HostSubnetBuilder>{
  public HostSubnetBuilder() {
    this(false);
  }
  public HostSubnetBuilder(java.lang.Boolean validationEnabled) {
    this(new HostSubnet(), validationEnabled);
  }
  public HostSubnetBuilder(io.fabric8.openshift.api.model.HostSubnetFluent<?> fluent) {
    this(fluent, false);
  }
  public HostSubnetBuilder(io.fabric8.openshift.api.model.HostSubnetFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new HostSubnet(), validationEnabled);
  }
  public HostSubnetBuilder(io.fabric8.openshift.api.model.HostSubnetFluent<?> fluent,io.fabric8.openshift.api.model.HostSubnet instance) {
    this(fluent, instance, false);
  }
  public HostSubnetBuilder(io.fabric8.openshift.api.model.HostSubnetFluent<?> fluent,io.fabric8.openshift.api.model.HostSubnet instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withEgressCIDRs(instance.getEgressCIDRs()); 
    fluent.withEgressIPs(instance.getEgressIPs()); 
    fluent.withHost(instance.getHost()); 
    fluent.withHostIP(instance.getHostIP()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSubnet(instance.getSubnet()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HostSubnetBuilder(io.fabric8.openshift.api.model.HostSubnet instance) {
    this(instance,false);
  }
  public HostSubnetBuilder(io.fabric8.openshift.api.model.HostSubnet instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withEgressCIDRs(instance.getEgressCIDRs()); 
    this.withEgressIPs(instance.getEgressIPs()); 
    this.withHost(instance.getHost()); 
    this.withHostIP(instance.getHostIP()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSubnet(instance.getSubnet()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.HostSubnetFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.HostSubnet build() {
    HostSubnet buildable = new HostSubnet(fluent.getApiVersion(),fluent.getEgressCIDRs(),fluent.getEgressIPs(),fluent.getHost(),fluent.getHostIP(),fluent.getKind(),fluent.getMetadata(),fluent.getSubnet());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HostSubnetBuilder that = (HostSubnetBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}