package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class BuildOutputBuilder extends io.fabric8.openshift.api.model.BuildOutputFluentImpl<io.fabric8.openshift.api.model.BuildOutputBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.BuildOutput,io.fabric8.openshift.api.model.BuildOutputBuilder>{
  public BuildOutputBuilder() {
    this(false);
  }
  public BuildOutputBuilder(java.lang.Boolean validationEnabled) {
    this(new BuildOutput(), validationEnabled);
  }
  public BuildOutputBuilder(io.fabric8.openshift.api.model.BuildOutputFluent<?> fluent) {
    this(fluent, false);
  }
  public BuildOutputBuilder(io.fabric8.openshift.api.model.BuildOutputFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new BuildOutput(), validationEnabled);
  }
  public BuildOutputBuilder(io.fabric8.openshift.api.model.BuildOutputFluent<?> fluent,io.fabric8.openshift.api.model.BuildOutput instance) {
    this(fluent, instance, false);
  }
  public BuildOutputBuilder(io.fabric8.openshift.api.model.BuildOutputFluent<?> fluent,io.fabric8.openshift.api.model.BuildOutput instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withImageLabels(instance.getImageLabels()); 
    fluent.withPushSecret(instance.getPushSecret()); 
    fluent.withTo(instance.getTo()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public BuildOutputBuilder(io.fabric8.openshift.api.model.BuildOutput instance) {
    this(instance,false);
  }
  public BuildOutputBuilder(io.fabric8.openshift.api.model.BuildOutput instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withImageLabels(instance.getImageLabels()); 
    this.withPushSecret(instance.getPushSecret()); 
    this.withTo(instance.getTo()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.BuildOutputFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.BuildOutput build() {
    BuildOutput buildable = new BuildOutput(fluent.getImageLabels(),fluent.getPushSecret(),fluent.getTo());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BuildOutputBuilder that = (BuildOutputBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}