package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class BuildVolumeBuilder extends io.fabric8.openshift.api.model.BuildVolumeFluentImpl<io.fabric8.openshift.api.model.BuildVolumeBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.BuildVolume,io.fabric8.openshift.api.model.BuildVolumeBuilder>{
  public BuildVolumeBuilder() {
    this(false);
  }
  public BuildVolumeBuilder(java.lang.Boolean validationEnabled) {
    this(new BuildVolume(), validationEnabled);
  }
  public BuildVolumeBuilder(io.fabric8.openshift.api.model.BuildVolumeFluent<?> fluent) {
    this(fluent, false);
  }
  public BuildVolumeBuilder(io.fabric8.openshift.api.model.BuildVolumeFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new BuildVolume(), validationEnabled);
  }
  public BuildVolumeBuilder(io.fabric8.openshift.api.model.BuildVolumeFluent<?> fluent,io.fabric8.openshift.api.model.BuildVolume instance) {
    this(fluent, instance, false);
  }
  public BuildVolumeBuilder(io.fabric8.openshift.api.model.BuildVolumeFluent<?> fluent,io.fabric8.openshift.api.model.BuildVolume instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMounts(instance.getMounts()); 
    fluent.withName(instance.getName()); 
    fluent.withSource(instance.getSource()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public BuildVolumeBuilder(io.fabric8.openshift.api.model.BuildVolume instance) {
    this(instance,false);
  }
  public BuildVolumeBuilder(io.fabric8.openshift.api.model.BuildVolume instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withMounts(instance.getMounts()); 
    this.withName(instance.getName()); 
    this.withSource(instance.getSource()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.BuildVolumeFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.BuildVolume build() {
    BuildVolume buildable = new BuildVolume(fluent.getMounts(),fluent.getName(),fluent.getSource());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BuildVolumeBuilder that = (BuildVolumeBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}