package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public class ClusterNetworkFluentImpl<A extends io.fabric8.openshift.api.model.ClusterNetworkFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.ClusterNetworkFluent<A>{
  public ClusterNetworkFluentImpl() {
  }
  public ClusterNetworkFluentImpl(io.fabric8.openshift.api.model.ClusterNetwork instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withClusterNetworks(instance.getClusterNetworks()); 
    this.withHostsubnetlength(instance.getHostsubnetlength()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withMtu(instance.getMtu()); 
    this.withNetwork(instance.getNetwork()); 
    this.withPluginName(instance.getPluginName()); 
    this.withServiceNetwork(instance.getServiceNetwork()); 
    this.withVxlanPort(instance.getVxlanPort()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.lang.String apiVersion;
  private java.util.List<io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder> clusterNetworks =  new java.util.ArrayList<io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder>();
  private java.lang.Integer hostsubnetlength;
  private java.lang.String kind;
  private io.fabric8.kubernetes.api.model.ObjectMetaBuilder metadata;
  private java.lang.Integer mtu;
  private java.lang.String network;
  private java.lang.String pluginName;
  private java.lang.String serviceNetwork;
  private java.lang.Integer vxlanPort;
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public java.lang.String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(java.lang.String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public java.lang.Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  /**
   * Method is deprecated. use withApiVersion instead.
   */
  @java.lang.Deprecated
  public A withNewApiVersion(java.lang.String arg0) {
    return (A)withApiVersion(new String(arg0));
  }
  public A addToClusterNetworks(java.lang.Integer index,io.fabric8.openshift.api.model.ClusterNetworkEntry item) {
    if (this.clusterNetworks == null) {this.clusterNetworks = new java.util.ArrayList<io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder>();}
    io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetworks").add(index >= 0 ? index : _visitables.get("clusterNetworks").size(), builder);this.clusterNetworks.add(index >= 0 ? index : clusterNetworks.size(), builder); return (A)this;
  }
  public A setToClusterNetworks(java.lang.Integer index,io.fabric8.openshift.api.model.ClusterNetworkEntry item) {
    if (this.clusterNetworks == null) {this.clusterNetworks = new java.util.ArrayList<io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder>();}
    io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder(item);
    if (index < 0 || index >= _visitables.get("clusterNetworks").size()) { _visitables.get("clusterNetworks").add(builder); } else { _visitables.get("clusterNetworks").set(index, builder);}
    if (index < 0 || index >= clusterNetworks.size()) { clusterNetworks.add(builder); } else { clusterNetworks.set(index, builder);}
     return (A)this;
  }
  public A addToClusterNetworks(io.fabric8.openshift.api.model.ClusterNetworkEntry... items) {
    if (this.clusterNetworks == null) {this.clusterNetworks = new java.util.ArrayList<io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder>();}
    for (io.fabric8.openshift.api.model.ClusterNetworkEntry item : items) {io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetworks").add(builder);this.clusterNetworks.add(builder);} return (A)this;
  }
  public A addAllToClusterNetworks(java.util.Collection<io.fabric8.openshift.api.model.ClusterNetworkEntry> items) {
    if (this.clusterNetworks == null) {this.clusterNetworks = new java.util.ArrayList<io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder>();}
    for (io.fabric8.openshift.api.model.ClusterNetworkEntry item : items) {io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetworks").add(builder);this.clusterNetworks.add(builder);} return (A)this;
  }
  public A removeFromClusterNetworks(io.fabric8.openshift.api.model.ClusterNetworkEntry... items) {
    for (io.fabric8.openshift.api.model.ClusterNetworkEntry item : items) {io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetworks").remove(builder);if (this.clusterNetworks != null) {this.clusterNetworks.remove(builder);}} return (A)this;
  }
  public A removeAllFromClusterNetworks(java.util.Collection<io.fabric8.openshift.api.model.ClusterNetworkEntry> items) {
    for (io.fabric8.openshift.api.model.ClusterNetworkEntry item : items) {io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetworks").remove(builder);if (this.clusterNetworks != null) {this.clusterNetworks.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromClusterNetworks(java.util.function.Predicate<io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder> predicate) {
    if (clusterNetworks == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder> each = clusterNetworks.iterator();
    final List visitables = _visitables.get("clusterNetworks");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildClusterNetworks instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.ClusterNetworkEntry> getClusterNetworks() {
    return build(clusterNetworks);
  }
  public java.util.List<io.fabric8.openshift.api.model.ClusterNetworkEntry> buildClusterNetworks() {
    return build(clusterNetworks);
  }
  public io.fabric8.openshift.api.model.ClusterNetworkEntry buildClusterNetwork(java.lang.Integer index) {
    return this.clusterNetworks.get(index).build();
  }
  public io.fabric8.openshift.api.model.ClusterNetworkEntry buildFirstClusterNetwork() {
    return this.clusterNetworks.get(0).build();
  }
  public io.fabric8.openshift.api.model.ClusterNetworkEntry buildLastClusterNetwork() {
    return this.clusterNetworks.get(clusterNetworks.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.ClusterNetworkEntry buildMatchingClusterNetwork(java.util.function.Predicate<io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder> predicate) {
    for (io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder item: clusterNetworks) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingClusterNetwork(java.util.function.Predicate<io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder> predicate) {
    for (io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder item: clusterNetworks) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withClusterNetworks(java.util.List<io.fabric8.openshift.api.model.ClusterNetworkEntry> clusterNetworks) {
    if (this.clusterNetworks != null) { _visitables.get("clusterNetworks").removeAll(this.clusterNetworks);}
    if (clusterNetworks != null) {this.clusterNetworks = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.ClusterNetworkEntry item : clusterNetworks){this.addToClusterNetworks(item);}} else { this.clusterNetworks = null;} return (A) this;
  }
  public A withClusterNetworks(io.fabric8.openshift.api.model.ClusterNetworkEntry... clusterNetworks) {
    if (this.clusterNetworks != null) {this.clusterNetworks.clear();}
    if (clusterNetworks != null) {for (io.fabric8.openshift.api.model.ClusterNetworkEntry item :clusterNetworks){ this.addToClusterNetworks(item);}} return (A) this;
  }
  public java.lang.Boolean hasClusterNetworks() {
    return clusterNetworks != null && !clusterNetworks.isEmpty();
  }
  public A addNewClusterNetwork(java.lang.String cidr,java.lang.Integer hostSubnetLength) {
    return (A)addToClusterNetworks(new ClusterNetworkEntry(cidr, hostSubnetLength));
  }
  public io.fabric8.openshift.api.model.ClusterNetworkFluent.ClusterNetworksNested<A> addNewClusterNetwork() {
    return new io.fabric8.openshift.api.model.ClusterNetworkFluentImpl.ClusterNetworksNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterNetworkFluent.ClusterNetworksNested<A> addNewClusterNetworkLike(io.fabric8.openshift.api.model.ClusterNetworkEntry item) {
    return new io.fabric8.openshift.api.model.ClusterNetworkFluentImpl.ClusterNetworksNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.ClusterNetworkFluent.ClusterNetworksNested<A> setNewClusterNetworkLike(java.lang.Integer index,io.fabric8.openshift.api.model.ClusterNetworkEntry item) {
    return new io.fabric8.openshift.api.model.ClusterNetworkFluentImpl.ClusterNetworksNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.ClusterNetworkFluent.ClusterNetworksNested<A> editClusterNetwork(java.lang.Integer index) {
    if (clusterNetworks.size() <= index) throw new RuntimeException("Can't edit clusterNetworks. Index exceeds size.");
    return setNewClusterNetworkLike(index, buildClusterNetwork(index));
  }
  public io.fabric8.openshift.api.model.ClusterNetworkFluent.ClusterNetworksNested<A> editFirstClusterNetwork() {
    if (clusterNetworks.size() == 0) throw new RuntimeException("Can't edit first clusterNetworks. The list is empty.");
    return setNewClusterNetworkLike(0, buildClusterNetwork(0));
  }
  public io.fabric8.openshift.api.model.ClusterNetworkFluent.ClusterNetworksNested<A> editLastClusterNetwork() {
    int index = clusterNetworks.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last clusterNetworks. The list is empty.");
    return setNewClusterNetworkLike(index, buildClusterNetwork(index));
  }
  public io.fabric8.openshift.api.model.ClusterNetworkFluent.ClusterNetworksNested<A> editMatchingClusterNetwork(java.util.function.Predicate<io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder> predicate) {
    int index = -1;
    for (int i=0;i<clusterNetworks.size();i++) { 
    if (predicate.test(clusterNetworks.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching clusterNetworks. No match found.");
    return setNewClusterNetworkLike(index, buildClusterNetwork(index));
  }
  public java.lang.Integer getHostsubnetlength() {
    return this.hostsubnetlength;
  }
  public A withHostsubnetlength(java.lang.Integer hostsubnetlength) {
    this.hostsubnetlength=hostsubnetlength; return (A) this;
  }
  public java.lang.Boolean hasHostsubnetlength() {
    return this.hostsubnetlength != null;
  }
  public java.lang.String getKind() {
    return this.kind;
  }
  public A withKind(java.lang.String kind) {
    this.kind=kind; return (A) this;
  }
  public java.lang.Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * Method is deprecated. use withKind instead.
   */
  @java.lang.Deprecated
  public A withNewKind(java.lang.String arg0) {
    return (A)withKind(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
    return this.metadata!=null?this.metadata.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
    return this.metadata!=null?this.metadata.build():null;
  }
  public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
  }
  public java.lang.Boolean hasMetadata() {
    return this.metadata != null;
  }
  public io.fabric8.openshift.api.model.ClusterNetworkFluent.MetadataNested<A> withNewMetadata() {
    return new io.fabric8.openshift.api.model.ClusterNetworkFluentImpl.MetadataNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterNetworkFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return new io.fabric8.openshift.api.model.ClusterNetworkFluentImpl.MetadataNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.ClusterNetworkFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public io.fabric8.openshift.api.model.ClusterNetworkFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
  }
  public io.fabric8.openshift.api.model.ClusterNetworkFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public java.lang.Integer getMtu() {
    return this.mtu;
  }
  public A withMtu(java.lang.Integer mtu) {
    this.mtu=mtu; return (A) this;
  }
  public java.lang.Boolean hasMtu() {
    return this.mtu != null;
  }
  public java.lang.String getNetwork() {
    return this.network;
  }
  public A withNetwork(java.lang.String network) {
    this.network=network; return (A) this;
  }
  public java.lang.Boolean hasNetwork() {
    return this.network != null;
  }
  
  /**
   * Method is deprecated. use withNetwork instead.
   */
  @java.lang.Deprecated
  public A withNewNetwork(java.lang.String arg0) {
    return (A)withNetwork(new String(arg0));
  }
  public java.lang.String getPluginName() {
    return this.pluginName;
  }
  public A withPluginName(java.lang.String pluginName) {
    this.pluginName=pluginName; return (A) this;
  }
  public java.lang.Boolean hasPluginName() {
    return this.pluginName != null;
  }
  
  /**
   * Method is deprecated. use withPluginName instead.
   */
  @java.lang.Deprecated
  public A withNewPluginName(java.lang.String arg0) {
    return (A)withPluginName(new String(arg0));
  }
  public java.lang.String getServiceNetwork() {
    return this.serviceNetwork;
  }
  public A withServiceNetwork(java.lang.String serviceNetwork) {
    this.serviceNetwork=serviceNetwork; return (A) this;
  }
  public java.lang.Boolean hasServiceNetwork() {
    return this.serviceNetwork != null;
  }
  
  /**
   * Method is deprecated. use withServiceNetwork instead.
   */
  @java.lang.Deprecated
  public A withNewServiceNetwork(java.lang.String arg0) {
    return (A)withServiceNetwork(new String(arg0));
  }
  public java.lang.Integer getVxlanPort() {
    return this.vxlanPort;
  }
  public A withVxlanPort(java.lang.Integer vxlanPort) {
    this.vxlanPort=vxlanPort; return (A) this;
  }
  public java.lang.Boolean hasVxlanPort() {
    return this.vxlanPort != null;
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ClusterNetworkFluentImpl that = (ClusterNetworkFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (clusterNetworks != null ? !clusterNetworks.equals(that.clusterNetworks) :that.clusterNetworks != null) return false;
    if (hostsubnetlength != null ? !hostsubnetlength.equals(that.hostsubnetlength) :that.hostsubnetlength != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (mtu != null ? !mtu.equals(that.mtu) :that.mtu != null) return false;
    if (network != null ? !network.equals(that.network) :that.network != null) return false;
    if (pluginName != null ? !pluginName.equals(that.pluginName) :that.pluginName != null) return false;
    if (serviceNetwork != null ? !serviceNetwork.equals(that.serviceNetwork) :that.serviceNetwork != null) return false;
    if (vxlanPort != null ? !vxlanPort.equals(that.vxlanPort) :that.vxlanPort != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  clusterNetworks,  hostsubnetlength,  kind,  metadata,  mtu,  network,  pluginName,  serviceNetwork,  vxlanPort,  additionalProperties,  super.hashCode());
  }
  public class ClusterNetworksNestedImpl<N> extends io.fabric8.openshift.api.model.ClusterNetworkEntryFluentImpl<io.fabric8.openshift.api.model.ClusterNetworkFluent.ClusterNetworksNested<N>> implements io.fabric8.openshift.api.model.ClusterNetworkFluent.ClusterNetworksNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ClusterNetworksNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.ClusterNetworkEntry item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder(this, item);
    }
    ClusterNetworksNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder(this);
    }
    io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ClusterNetworkFluentImpl.this.setToClusterNetworks(index,builder.build());
    }
    public N endClusterNetwork() {
      return and();
    }
    
  }
  public class MetadataNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl<io.fabric8.openshift.api.model.ClusterNetworkFluent.MetadataNested<N>> implements io.fabric8.openshift.api.model.ClusterNetworkFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;
    public N and() {
      return (N) ClusterNetworkFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  
}