package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class PowerVSServiceEndpointBuilder extends io.fabric8.openshift.api.model.PowerVSServiceEndpointFluentImpl<io.fabric8.openshift.api.model.PowerVSServiceEndpointBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.PowerVSServiceEndpoint,io.fabric8.openshift.api.model.PowerVSServiceEndpointBuilder>{
  public PowerVSServiceEndpointBuilder() {
    this(false);
  }
  public PowerVSServiceEndpointBuilder(java.lang.Boolean validationEnabled) {
    this(new PowerVSServiceEndpoint(), validationEnabled);
  }
  public PowerVSServiceEndpointBuilder(io.fabric8.openshift.api.model.PowerVSServiceEndpointFluent<?> fluent) {
    this(fluent, false);
  }
  public PowerVSServiceEndpointBuilder(io.fabric8.openshift.api.model.PowerVSServiceEndpointFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PowerVSServiceEndpoint(), validationEnabled);
  }
  public PowerVSServiceEndpointBuilder(io.fabric8.openshift.api.model.PowerVSServiceEndpointFluent<?> fluent,io.fabric8.openshift.api.model.PowerVSServiceEndpoint instance) {
    this(fluent, instance, false);
  }
  public PowerVSServiceEndpointBuilder(io.fabric8.openshift.api.model.PowerVSServiceEndpointFluent<?> fluent,io.fabric8.openshift.api.model.PowerVSServiceEndpoint instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withUrl(instance.getUrl()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PowerVSServiceEndpointBuilder(io.fabric8.openshift.api.model.PowerVSServiceEndpoint instance) {
    this(instance,false);
  }
  public PowerVSServiceEndpointBuilder(io.fabric8.openshift.api.model.PowerVSServiceEndpoint instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withUrl(instance.getUrl()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.PowerVSServiceEndpointFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.PowerVSServiceEndpoint build() {
    PowerVSServiceEndpoint buildable = new PowerVSServiceEndpoint(fluent.getName(),fluent.getUrl());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PowerVSServiceEndpointBuilder that = (PowerVSServiceEndpointBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}