/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.ComponentRouteSpec;
import io.fabric8.openshift.api.model.ComponentRouteSpecBuilder;
import io.fabric8.openshift.api.model.ComponentRouteSpecFluentImpl;
import io.fabric8.openshift.api.model.IngressSpec;
import io.fabric8.openshift.api.model.IngressSpecFluent;
import io.fabric8.openshift.api.model.RequiredHSTSPolicy;
import io.fabric8.openshift.api.model.RequiredHSTSPolicyBuilder;
import io.fabric8.openshift.api.model.RequiredHSTSPolicyFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class IngressSpecFluentImpl<A extends IngressSpecFluent<A>>
extends BaseFluent<A>
implements IngressSpecFluent<A> {
    private String appsDomain;
    private List<ComponentRouteSpecBuilder> componentRoutes = new ArrayList<ComponentRouteSpecBuilder>();
    private String domain;
    private List<RequiredHSTSPolicyBuilder> requiredHSTSPolicies = new ArrayList<RequiredHSTSPolicyBuilder>();
    private Map<String, Object> additionalProperties;

    public IngressSpecFluentImpl() {
    }

    public IngressSpecFluentImpl(IngressSpec instance) {
        this.withAppsDomain(instance.getAppsDomain());
        this.withComponentRoutes(instance.getComponentRoutes());
        this.withDomain(instance.getDomain());
        this.withRequiredHSTSPolicies(instance.getRequiredHSTSPolicies());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getAppsDomain() {
        return this.appsDomain;
    }

    @Override
    public A withAppsDomain(String appsDomain) {
        this.appsDomain = appsDomain;
        return (A)this;
    }

    @Override
    public Boolean hasAppsDomain() {
        return this.appsDomain != null;
    }

    @Override
    @Deprecated
    public A withNewAppsDomain(String arg0) {
        return this.withAppsDomain(new String(arg0));
    }

    @Override
    public A addToComponentRoutes(Integer index, ComponentRouteSpec item) {
        if (this.componentRoutes == null) {
            this.componentRoutes = new ArrayList<ComponentRouteSpecBuilder>();
        }
        ComponentRouteSpecBuilder builder = new ComponentRouteSpecBuilder(item);
        this._visitables.get((Object)"componentRoutes").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"componentRoutes").size(), builder);
        this.componentRoutes.add(index >= 0 ? index.intValue() : this.componentRoutes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToComponentRoutes(Integer index, ComponentRouteSpec item) {
        if (this.componentRoutes == null) {
            this.componentRoutes = new ArrayList<ComponentRouteSpecBuilder>();
        }
        ComponentRouteSpecBuilder builder = new ComponentRouteSpecBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"componentRoutes").size()) {
            this._visitables.get((Object)"componentRoutes").add(builder);
        } else {
            this._visitables.get((Object)"componentRoutes").set(index, builder);
        }
        if (index < 0 || index >= this.componentRoutes.size()) {
            this.componentRoutes.add(builder);
        } else {
            this.componentRoutes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToComponentRoutes(ComponentRouteSpec ... items) {
        if (this.componentRoutes == null) {
            this.componentRoutes = new ArrayList<ComponentRouteSpecBuilder>();
        }
        for (ComponentRouteSpec item : items) {
            ComponentRouteSpecBuilder builder = new ComponentRouteSpecBuilder(item);
            this._visitables.get((Object)"componentRoutes").add(builder);
            this.componentRoutes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToComponentRoutes(Collection<ComponentRouteSpec> items) {
        if (this.componentRoutes == null) {
            this.componentRoutes = new ArrayList<ComponentRouteSpecBuilder>();
        }
        for (ComponentRouteSpec item : items) {
            ComponentRouteSpecBuilder builder = new ComponentRouteSpecBuilder(item);
            this._visitables.get((Object)"componentRoutes").add(builder);
            this.componentRoutes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromComponentRoutes(ComponentRouteSpec ... items) {
        for (ComponentRouteSpec item : items) {
            ComponentRouteSpecBuilder builder = new ComponentRouteSpecBuilder(item);
            this._visitables.get((Object)"componentRoutes").remove(builder);
            if (this.componentRoutes == null) continue;
            this.componentRoutes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromComponentRoutes(Collection<ComponentRouteSpec> items) {
        for (ComponentRouteSpec item : items) {
            ComponentRouteSpecBuilder builder = new ComponentRouteSpecBuilder(item);
            this._visitables.get((Object)"componentRoutes").remove(builder);
            if (this.componentRoutes == null) continue;
            this.componentRoutes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromComponentRoutes(Predicate<ComponentRouteSpecBuilder> predicate) {
        if (this.componentRoutes == null) {
            return (A)this;
        }
        Iterator<ComponentRouteSpecBuilder> each = this.componentRoutes.iterator();
        List visitables = this._visitables.get((Object)"componentRoutes");
        while (each.hasNext()) {
            ComponentRouteSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ComponentRouteSpec> getComponentRoutes() {
        return IngressSpecFluentImpl.build(this.componentRoutes);
    }

    @Override
    public List<ComponentRouteSpec> buildComponentRoutes() {
        return IngressSpecFluentImpl.build(this.componentRoutes);
    }

    @Override
    public ComponentRouteSpec buildComponentRoute(Integer index) {
        return this.componentRoutes.get(index).build();
    }

    @Override
    public ComponentRouteSpec buildFirstComponentRoute() {
        return this.componentRoutes.get(0).build();
    }

    @Override
    public ComponentRouteSpec buildLastComponentRoute() {
        return this.componentRoutes.get(this.componentRoutes.size() - 1).build();
    }

    @Override
    public ComponentRouteSpec buildMatchingComponentRoute(Predicate<ComponentRouteSpecBuilder> predicate) {
        for (ComponentRouteSpecBuilder item : this.componentRoutes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingComponentRoute(Predicate<ComponentRouteSpecBuilder> predicate) {
        for (ComponentRouteSpecBuilder item : this.componentRoutes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withComponentRoutes(List<ComponentRouteSpec> componentRoutes) {
        if (this.componentRoutes != null) {
            this._visitables.get((Object)"componentRoutes").removeAll(this.componentRoutes);
        }
        if (componentRoutes != null) {
            this.componentRoutes = new ArrayList<ComponentRouteSpecBuilder>();
            for (ComponentRouteSpec item : componentRoutes) {
                this.addToComponentRoutes(item);
            }
        } else {
            this.componentRoutes = null;
        }
        return (A)this;
    }

    @Override
    public A withComponentRoutes(ComponentRouteSpec ... componentRoutes) {
        if (this.componentRoutes != null) {
            this.componentRoutes.clear();
        }
        if (componentRoutes != null) {
            for (ComponentRouteSpec item : componentRoutes) {
                this.addToComponentRoutes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasComponentRoutes() {
        return this.componentRoutes != null && !this.componentRoutes.isEmpty();
    }

    @Override
    public IngressSpecFluent.ComponentRoutesNested<A> addNewComponentRoute() {
        return new ComponentRoutesNestedImpl();
    }

    @Override
    public IngressSpecFluent.ComponentRoutesNested<A> addNewComponentRouteLike(ComponentRouteSpec item) {
        return new ComponentRoutesNestedImpl(-1, item);
    }

    @Override
    public IngressSpecFluent.ComponentRoutesNested<A> setNewComponentRouteLike(Integer index, ComponentRouteSpec item) {
        return new ComponentRoutesNestedImpl(index, item);
    }

    @Override
    public IngressSpecFluent.ComponentRoutesNested<A> editComponentRoute(Integer index) {
        if (this.componentRoutes.size() <= index) {
            throw new RuntimeException("Can't edit componentRoutes. Index exceeds size.");
        }
        return this.setNewComponentRouteLike(index, this.buildComponentRoute(index));
    }

    @Override
    public IngressSpecFluent.ComponentRoutesNested<A> editFirstComponentRoute() {
        if (this.componentRoutes.size() == 0) {
            throw new RuntimeException("Can't edit first componentRoutes. The list is empty.");
        }
        return this.setNewComponentRouteLike(0, this.buildComponentRoute(0));
    }

    @Override
    public IngressSpecFluent.ComponentRoutesNested<A> editLastComponentRoute() {
        int index = this.componentRoutes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last componentRoutes. The list is empty.");
        }
        return this.setNewComponentRouteLike(index, this.buildComponentRoute(index));
    }

    @Override
    public IngressSpecFluent.ComponentRoutesNested<A> editMatchingComponentRoute(Predicate<ComponentRouteSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.componentRoutes.size(); ++i) {
            if (!predicate.test(this.componentRoutes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching componentRoutes. No match found.");
        }
        return this.setNewComponentRouteLike(index, this.buildComponentRoute(index));
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public A withDomain(String domain) {
        this.domain = domain;
        return (A)this;
    }

    @Override
    public Boolean hasDomain() {
        return this.domain != null;
    }

    @Override
    @Deprecated
    public A withNewDomain(String arg0) {
        return this.withDomain(new String(arg0));
    }

    @Override
    public A addToRequiredHSTSPolicies(Integer index, RequiredHSTSPolicy item) {
        if (this.requiredHSTSPolicies == null) {
            this.requiredHSTSPolicies = new ArrayList<RequiredHSTSPolicyBuilder>();
        }
        RequiredHSTSPolicyBuilder builder = new RequiredHSTSPolicyBuilder(item);
        this._visitables.get((Object)"requiredHSTSPolicies").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"requiredHSTSPolicies").size(), builder);
        this.requiredHSTSPolicies.add(index >= 0 ? index.intValue() : this.requiredHSTSPolicies.size(), builder);
        return (A)this;
    }

    @Override
    public A setToRequiredHSTSPolicies(Integer index, RequiredHSTSPolicy item) {
        if (this.requiredHSTSPolicies == null) {
            this.requiredHSTSPolicies = new ArrayList<RequiredHSTSPolicyBuilder>();
        }
        RequiredHSTSPolicyBuilder builder = new RequiredHSTSPolicyBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"requiredHSTSPolicies").size()) {
            this._visitables.get((Object)"requiredHSTSPolicies").add(builder);
        } else {
            this._visitables.get((Object)"requiredHSTSPolicies").set(index, builder);
        }
        if (index < 0 || index >= this.requiredHSTSPolicies.size()) {
            this.requiredHSTSPolicies.add(builder);
        } else {
            this.requiredHSTSPolicies.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToRequiredHSTSPolicies(RequiredHSTSPolicy ... items) {
        if (this.requiredHSTSPolicies == null) {
            this.requiredHSTSPolicies = new ArrayList<RequiredHSTSPolicyBuilder>();
        }
        for (RequiredHSTSPolicy item : items) {
            RequiredHSTSPolicyBuilder builder = new RequiredHSTSPolicyBuilder(item);
            this._visitables.get((Object)"requiredHSTSPolicies").add(builder);
            this.requiredHSTSPolicies.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToRequiredHSTSPolicies(Collection<RequiredHSTSPolicy> items) {
        if (this.requiredHSTSPolicies == null) {
            this.requiredHSTSPolicies = new ArrayList<RequiredHSTSPolicyBuilder>();
        }
        for (RequiredHSTSPolicy item : items) {
            RequiredHSTSPolicyBuilder builder = new RequiredHSTSPolicyBuilder(item);
            this._visitables.get((Object)"requiredHSTSPolicies").add(builder);
            this.requiredHSTSPolicies.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRequiredHSTSPolicies(RequiredHSTSPolicy ... items) {
        for (RequiredHSTSPolicy item : items) {
            RequiredHSTSPolicyBuilder builder = new RequiredHSTSPolicyBuilder(item);
            this._visitables.get((Object)"requiredHSTSPolicies").remove(builder);
            if (this.requiredHSTSPolicies == null) continue;
            this.requiredHSTSPolicies.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRequiredHSTSPolicies(Collection<RequiredHSTSPolicy> items) {
        for (RequiredHSTSPolicy item : items) {
            RequiredHSTSPolicyBuilder builder = new RequiredHSTSPolicyBuilder(item);
            this._visitables.get((Object)"requiredHSTSPolicies").remove(builder);
            if (this.requiredHSTSPolicies == null) continue;
            this.requiredHSTSPolicies.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromRequiredHSTSPolicies(Predicate<RequiredHSTSPolicyBuilder> predicate) {
        if (this.requiredHSTSPolicies == null) {
            return (A)this;
        }
        Iterator<RequiredHSTSPolicyBuilder> each = this.requiredHSTSPolicies.iterator();
        List visitables = this._visitables.get((Object)"requiredHSTSPolicies");
        while (each.hasNext()) {
            RequiredHSTSPolicyBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<RequiredHSTSPolicy> getRequiredHSTSPolicies() {
        return IngressSpecFluentImpl.build(this.requiredHSTSPolicies);
    }

    @Override
    public List<RequiredHSTSPolicy> buildRequiredHSTSPolicies() {
        return IngressSpecFluentImpl.build(this.requiredHSTSPolicies);
    }

    @Override
    public RequiredHSTSPolicy buildRequiredHSTSPolicy(Integer index) {
        return this.requiredHSTSPolicies.get(index).build();
    }

    @Override
    public RequiredHSTSPolicy buildFirstRequiredHSTSPolicy() {
        return this.requiredHSTSPolicies.get(0).build();
    }

    @Override
    public RequiredHSTSPolicy buildLastRequiredHSTSPolicy() {
        return this.requiredHSTSPolicies.get(this.requiredHSTSPolicies.size() - 1).build();
    }

    @Override
    public RequiredHSTSPolicy buildMatchingRequiredHSTSPolicy(Predicate<RequiredHSTSPolicyBuilder> predicate) {
        for (RequiredHSTSPolicyBuilder item : this.requiredHSTSPolicies) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRequiredHSTSPolicy(Predicate<RequiredHSTSPolicyBuilder> predicate) {
        for (RequiredHSTSPolicyBuilder item : this.requiredHSTSPolicies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRequiredHSTSPolicies(List<RequiredHSTSPolicy> requiredHSTSPolicies) {
        if (this.requiredHSTSPolicies != null) {
            this._visitables.get((Object)"requiredHSTSPolicies").removeAll(this.requiredHSTSPolicies);
        }
        if (requiredHSTSPolicies != null) {
            this.requiredHSTSPolicies = new ArrayList<RequiredHSTSPolicyBuilder>();
            for (RequiredHSTSPolicy item : requiredHSTSPolicies) {
                this.addToRequiredHSTSPolicies(item);
            }
        } else {
            this.requiredHSTSPolicies = null;
        }
        return (A)this;
    }

    @Override
    public A withRequiredHSTSPolicies(RequiredHSTSPolicy ... requiredHSTSPolicies) {
        if (this.requiredHSTSPolicies != null) {
            this.requiredHSTSPolicies.clear();
        }
        if (requiredHSTSPolicies != null) {
            for (RequiredHSTSPolicy item : requiredHSTSPolicies) {
                this.addToRequiredHSTSPolicies(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRequiredHSTSPolicies() {
        return this.requiredHSTSPolicies != null && !this.requiredHSTSPolicies.isEmpty();
    }

    @Override
    public IngressSpecFluent.RequiredHSTSPoliciesNested<A> addNewRequiredHSTSPolicy() {
        return new RequiredHSTSPoliciesNestedImpl();
    }

    @Override
    public IngressSpecFluent.RequiredHSTSPoliciesNested<A> addNewRequiredHSTSPolicyLike(RequiredHSTSPolicy item) {
        return new RequiredHSTSPoliciesNestedImpl(-1, item);
    }

    @Override
    public IngressSpecFluent.RequiredHSTSPoliciesNested<A> setNewRequiredHSTSPolicyLike(Integer index, RequiredHSTSPolicy item) {
        return new RequiredHSTSPoliciesNestedImpl(index, item);
    }

    @Override
    public IngressSpecFluent.RequiredHSTSPoliciesNested<A> editRequiredHSTSPolicy(Integer index) {
        if (this.requiredHSTSPolicies.size() <= index) {
            throw new RuntimeException("Can't edit requiredHSTSPolicies. Index exceeds size.");
        }
        return this.setNewRequiredHSTSPolicyLike(index, this.buildRequiredHSTSPolicy(index));
    }

    @Override
    public IngressSpecFluent.RequiredHSTSPoliciesNested<A> editFirstRequiredHSTSPolicy() {
        if (this.requiredHSTSPolicies.size() == 0) {
            throw new RuntimeException("Can't edit first requiredHSTSPolicies. The list is empty.");
        }
        return this.setNewRequiredHSTSPolicyLike(0, this.buildRequiredHSTSPolicy(0));
    }

    @Override
    public IngressSpecFluent.RequiredHSTSPoliciesNested<A> editLastRequiredHSTSPolicy() {
        int index = this.requiredHSTSPolicies.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last requiredHSTSPolicies. The list is empty.");
        }
        return this.setNewRequiredHSTSPolicyLike(index, this.buildRequiredHSTSPolicy(index));
    }

    @Override
    public IngressSpecFluent.RequiredHSTSPoliciesNested<A> editMatchingRequiredHSTSPolicy(Predicate<RequiredHSTSPolicyBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.requiredHSTSPolicies.size(); ++i) {
            if (!predicate.test(this.requiredHSTSPolicies.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching requiredHSTSPolicies. No match found.");
        }
        return this.setNewRequiredHSTSPolicyLike(index, this.buildRequiredHSTSPolicy(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngressSpecFluentImpl that = (IngressSpecFluentImpl)o;
        if (this.appsDomain != null ? !this.appsDomain.equals(that.appsDomain) : that.appsDomain != null) {
            return false;
        }
        if (this.componentRoutes != null ? !this.componentRoutes.equals(that.componentRoutes) : that.componentRoutes != null) {
            return false;
        }
        if (this.domain != null ? !this.domain.equals(that.domain) : that.domain != null) {
            return false;
        }
        if (this.requiredHSTSPolicies != null ? !this.requiredHSTSPolicies.equals(that.requiredHSTSPolicies) : that.requiredHSTSPolicies != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.appsDomain, this.componentRoutes, this.domain, this.requiredHSTSPolicies, this.additionalProperties, super.hashCode());
    }

    public class RequiredHSTSPoliciesNestedImpl<N>
    extends RequiredHSTSPolicyFluentImpl<IngressSpecFluent.RequiredHSTSPoliciesNested<N>>
    implements IngressSpecFluent.RequiredHSTSPoliciesNested<N>,
    Nested<N> {
        RequiredHSTSPolicyBuilder builder;
        Integer index;

        RequiredHSTSPoliciesNestedImpl(Integer index, RequiredHSTSPolicy item) {
            this.index = index;
            this.builder = new RequiredHSTSPolicyBuilder(this, item);
        }

        RequiredHSTSPoliciesNestedImpl() {
            this.index = -1;
            this.builder = new RequiredHSTSPolicyBuilder(this);
        }

        @Override
        public N and() {
            return (N)IngressSpecFluentImpl.this.setToRequiredHSTSPolicies(this.index, this.builder.build());
        }

        @Override
        public N endRequiredHSTSPolicy() {
            return this.and();
        }
    }

    public class ComponentRoutesNestedImpl<N>
    extends ComponentRouteSpecFluentImpl<IngressSpecFluent.ComponentRoutesNested<N>>
    implements IngressSpecFluent.ComponentRoutesNested<N>,
    Nested<N> {
        ComponentRouteSpecBuilder builder;
        Integer index;

        ComponentRoutesNestedImpl(Integer index, ComponentRouteSpec item) {
            this.index = index;
            this.builder = new ComponentRouteSpecBuilder(this, item);
        }

        ComponentRoutesNestedImpl() {
            this.index = -1;
            this.builder = new ComponentRouteSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)IngressSpecFluentImpl.this.setToComponentRoutes(this.index, this.builder.build());
        }

        @Override
        public N endComponentRoute() {
            return this.and();
        }
    }
}

