package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ConditionalUpdateBuilder extends io.fabric8.openshift.api.model.ConditionalUpdateFluentImpl<io.fabric8.openshift.api.model.ConditionalUpdateBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.ConditionalUpdate,io.fabric8.openshift.api.model.ConditionalUpdateBuilder>{
  public ConditionalUpdateBuilder() {
    this(false);
  }
  public ConditionalUpdateBuilder(java.lang.Boolean validationEnabled) {
    this(new ConditionalUpdate(), validationEnabled);
  }
  public ConditionalUpdateBuilder(io.fabric8.openshift.api.model.ConditionalUpdateFluent<?> fluent) {
    this(fluent, false);
  }
  public ConditionalUpdateBuilder(io.fabric8.openshift.api.model.ConditionalUpdateFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ConditionalUpdate(), validationEnabled);
  }
  public ConditionalUpdateBuilder(io.fabric8.openshift.api.model.ConditionalUpdateFluent<?> fluent,io.fabric8.openshift.api.model.ConditionalUpdate instance) {
    this(fluent, instance, false);
  }
  public ConditionalUpdateBuilder(io.fabric8.openshift.api.model.ConditionalUpdateFluent<?> fluent,io.fabric8.openshift.api.model.ConditionalUpdate instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConditions(instance.getConditions()); 
    fluent.withRelease(instance.getRelease()); 
    fluent.withRisks(instance.getRisks()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConditionalUpdateBuilder(io.fabric8.openshift.api.model.ConditionalUpdate instance) {
    this(instance,false);
  }
  public ConditionalUpdateBuilder(io.fabric8.openshift.api.model.ConditionalUpdate instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withConditions(instance.getConditions()); 
    this.withRelease(instance.getRelease()); 
    this.withRisks(instance.getRisks()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ConditionalUpdateFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ConditionalUpdate build() {
    ConditionalUpdate buildable = new ConditionalUpdate(fluent.getConditions(),fluent.getRelease(),fluent.getRisks());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ConditionalUpdateBuilder that = (ConditionalUpdateBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}