package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class RoleBindingBuilder extends io.fabric8.openshift.api.model.RoleBindingFluentImpl<io.fabric8.openshift.api.model.RoleBindingBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.RoleBinding,io.fabric8.openshift.api.model.RoleBindingBuilder>{
  public RoleBindingBuilder() {
    this(false);
  }
  public RoleBindingBuilder(java.lang.Boolean validationEnabled) {
    this(new RoleBinding(), validationEnabled);
  }
  public RoleBindingBuilder(io.fabric8.openshift.api.model.RoleBindingFluent<?> fluent) {
    this(fluent, false);
  }
  public RoleBindingBuilder(io.fabric8.openshift.api.model.RoleBindingFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new RoleBinding(), validationEnabled);
  }
  public RoleBindingBuilder(io.fabric8.openshift.api.model.RoleBindingFluent<?> fluent,io.fabric8.openshift.api.model.RoleBinding instance) {
    this(fluent, instance, false);
  }
  public RoleBindingBuilder(io.fabric8.openshift.api.model.RoleBindingFluent<?> fluent,io.fabric8.openshift.api.model.RoleBinding instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withGroupNames(instance.getGroupNames()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withRoleRef(instance.getRoleRef()); 
    fluent.withSubjects(instance.getSubjects()); 
    fluent.withUserNames(instance.getUserNames()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RoleBindingBuilder(io.fabric8.openshift.api.model.RoleBinding instance) {
    this(instance,false);
  }
  public RoleBindingBuilder(io.fabric8.openshift.api.model.RoleBinding instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withGroupNames(instance.getGroupNames()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withRoleRef(instance.getRoleRef()); 
    this.withSubjects(instance.getSubjects()); 
    this.withUserNames(instance.getUserNames()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.RoleBindingFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.RoleBinding build() {
    RoleBinding buildable = new RoleBinding(fluent.getApiVersion(),fluent.getGroupNames(),fluent.getKind(),fluent.getMetadata(),fluent.getRoleRef(),fluent.getSubjects(),fluent.getUserNames());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RoleBindingBuilder that = (RoleBindingBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}