package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class AWSServiceEndpointBuilder extends io.fabric8.openshift.api.model.AWSServiceEndpointFluentImpl<io.fabric8.openshift.api.model.AWSServiceEndpointBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.AWSServiceEndpoint,io.fabric8.openshift.api.model.AWSServiceEndpointBuilder>{
  public AWSServiceEndpointBuilder() {
    this(false);
  }
  public AWSServiceEndpointBuilder(java.lang.Boolean validationEnabled) {
    this(new AWSServiceEndpoint(), validationEnabled);
  }
  public AWSServiceEndpointBuilder(io.fabric8.openshift.api.model.AWSServiceEndpointFluent<?> fluent) {
    this(fluent, false);
  }
  public AWSServiceEndpointBuilder(io.fabric8.openshift.api.model.AWSServiceEndpointFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new AWSServiceEndpoint(), validationEnabled);
  }
  public AWSServiceEndpointBuilder(io.fabric8.openshift.api.model.AWSServiceEndpointFluent<?> fluent,io.fabric8.openshift.api.model.AWSServiceEndpoint instance) {
    this(fluent, instance, false);
  }
  public AWSServiceEndpointBuilder(io.fabric8.openshift.api.model.AWSServiceEndpointFluent<?> fluent,io.fabric8.openshift.api.model.AWSServiceEndpoint instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withUrl(instance.getUrl()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public AWSServiceEndpointBuilder(io.fabric8.openshift.api.model.AWSServiceEndpoint instance) {
    this(instance,false);
  }
  public AWSServiceEndpointBuilder(io.fabric8.openshift.api.model.AWSServiceEndpoint instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withUrl(instance.getUrl()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.AWSServiceEndpointFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.AWSServiceEndpoint build() {
    AWSServiceEndpoint buildable = new AWSServiceEndpoint(fluent.getName(),fluent.getUrl());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AWSServiceEndpointBuilder that = (AWSServiceEndpointBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}