package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.Condition;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public class HelmChartRepositoryStatusFluentImpl<A extends io.fabric8.openshift.api.model.HelmChartRepositoryStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.HelmChartRepositoryStatusFluent<A>{
  public HelmChartRepositoryStatusFluentImpl() {
  }
  public HelmChartRepositoryStatusFluentImpl(io.fabric8.openshift.api.model.HelmChartRepositoryStatus instance) {
    this.withConditions(instance.getConditions()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.util.List<io.fabric8.kubernetes.api.model.Condition> conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public A addToConditions(java.lang.Integer index,io.fabric8.kubernetes.api.model.Condition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();}
    this.conditions.add(index, item);
    return (A)this;
  }
  public A setToConditions(java.lang.Integer index,io.fabric8.kubernetes.api.model.Condition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();}
    this.conditions.set(index, item); return (A)this;
  }
  public A addToConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();}
    for (io.fabric8.kubernetes.api.model.Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A addAllToConditions(java.util.Collection<io.fabric8.kubernetes.api.model.Condition> items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();}
    for (io.fabric8.kubernetes.api.model.Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    for (io.fabric8.kubernetes.api.model.Condition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
  }
  public A removeAllFromConditions(java.util.Collection<io.fabric8.kubernetes.api.model.Condition> items) {
    for (io.fabric8.kubernetes.api.model.Condition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.Condition> getConditions() {
    return this.conditions;
  }
  public io.fabric8.kubernetes.api.model.Condition getCondition(java.lang.Integer index) {
    return this.conditions.get(index);
  }
  public io.fabric8.kubernetes.api.model.Condition getFirstCondition() {
    return this.conditions.get(0);
  }
  public io.fabric8.kubernetes.api.model.Condition getLastCondition() {
    return this.conditions.get(conditions.size() - 1);
  }
  public io.fabric8.kubernetes.api.model.Condition getMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.Condition> predicate) {
    for (io.fabric8.kubernetes.api.model.Condition item: conditions) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.Condition> predicate) {
    for (io.fabric8.kubernetes.api.model.Condition item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(java.util.List<io.fabric8.kubernetes.api.model.Condition> conditions) {
    if (conditions != null) {this.conditions = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.kubernetes.api.model.Condition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (io.fabric8.kubernetes.api.model.Condition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public java.lang.Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HelmChartRepositoryStatusFluentImpl that = (HelmChartRepositoryStatusFluentImpl) o;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  additionalProperties,  super.hashCode());
  }
  
}