package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ReleaseBuilder extends io.fabric8.openshift.api.model.ReleaseFluentImpl<io.fabric8.openshift.api.model.ReleaseBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.Release,io.fabric8.openshift.api.model.ReleaseBuilder>{
  public ReleaseBuilder() {
    this(false);
  }
  public ReleaseBuilder(java.lang.Boolean validationEnabled) {
    this(new Release(), validationEnabled);
  }
  public ReleaseBuilder(io.fabric8.openshift.api.model.ReleaseFluent<?> fluent) {
    this(fluent, false);
  }
  public ReleaseBuilder(io.fabric8.openshift.api.model.ReleaseFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Release(), validationEnabled);
  }
  public ReleaseBuilder(io.fabric8.openshift.api.model.ReleaseFluent<?> fluent,io.fabric8.openshift.api.model.Release instance) {
    this(fluent, instance, false);
  }
  public ReleaseBuilder(io.fabric8.openshift.api.model.ReleaseFluent<?> fluent,io.fabric8.openshift.api.model.Release instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withChannels(instance.getChannels()); 
    fluent.withImage(instance.getImage()); 
    fluent.withUrl(instance.getUrl()); 
    fluent.withVersion(instance.getVersion()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ReleaseBuilder(io.fabric8.openshift.api.model.Release instance) {
    this(instance,false);
  }
  public ReleaseBuilder(io.fabric8.openshift.api.model.Release instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withChannels(instance.getChannels()); 
    this.withImage(instance.getImage()); 
    this.withUrl(instance.getUrl()); 
    this.withVersion(instance.getVersion()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ReleaseFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.Release build() {
    Release buildable = new Release(fluent.getChannels(),fluent.getImage(),fluent.getUrl(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ReleaseBuilder that = (ReleaseBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}