package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public class ImageStreamStatusFluentImpl<A extends io.fabric8.openshift.api.model.ImageStreamStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.ImageStreamStatusFluent<A>{
  public ImageStreamStatusFluentImpl() {
  }
  public ImageStreamStatusFluentImpl(io.fabric8.openshift.api.model.ImageStreamStatus instance) {
    this.withDockerImageRepository(instance.getDockerImageRepository()); 
    this.withPublicDockerImageRepository(instance.getPublicDockerImageRepository()); 
    this.withTags(instance.getTags()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.lang.String dockerImageRepository;
  private java.lang.String publicDockerImageRepository;
  private java.util.List<io.fabric8.openshift.api.model.NamedTagEventListBuilder> tags =  new java.util.ArrayList<io.fabric8.openshift.api.model.NamedTagEventListBuilder>();
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public java.lang.String getDockerImageRepository() {
    return this.dockerImageRepository;
  }
  public A withDockerImageRepository(java.lang.String dockerImageRepository) {
    this.dockerImageRepository=dockerImageRepository; return (A) this;
  }
  public java.lang.Boolean hasDockerImageRepository() {
    return this.dockerImageRepository != null;
  }
  
  /**
   * Method is deprecated. use withDockerImageRepository instead.
   */
  @java.lang.Deprecated
  public A withNewDockerImageRepository(java.lang.String arg0) {
    return (A)withDockerImageRepository(new String(arg0));
  }
  public java.lang.String getPublicDockerImageRepository() {
    return this.publicDockerImageRepository;
  }
  public A withPublicDockerImageRepository(java.lang.String publicDockerImageRepository) {
    this.publicDockerImageRepository=publicDockerImageRepository; return (A) this;
  }
  public java.lang.Boolean hasPublicDockerImageRepository() {
    return this.publicDockerImageRepository != null;
  }
  
  /**
   * Method is deprecated. use withPublicDockerImageRepository instead.
   */
  @java.lang.Deprecated
  public A withNewPublicDockerImageRepository(java.lang.String arg0) {
    return (A)withPublicDockerImageRepository(new String(arg0));
  }
  public A addToTags(java.lang.Integer index,io.fabric8.openshift.api.model.NamedTagEventList item) {
    if (this.tags == null) {this.tags = new java.util.ArrayList<io.fabric8.openshift.api.model.NamedTagEventListBuilder>();}
    io.fabric8.openshift.api.model.NamedTagEventListBuilder builder = new io.fabric8.openshift.api.model.NamedTagEventListBuilder(item);_visitables.get("tags").add(index >= 0 ? index : _visitables.get("tags").size(), builder);this.tags.add(index >= 0 ? index : tags.size(), builder); return (A)this;
  }
  public A setToTags(java.lang.Integer index,io.fabric8.openshift.api.model.NamedTagEventList item) {
    if (this.tags == null) {this.tags = new java.util.ArrayList<io.fabric8.openshift.api.model.NamedTagEventListBuilder>();}
    io.fabric8.openshift.api.model.NamedTagEventListBuilder builder = new io.fabric8.openshift.api.model.NamedTagEventListBuilder(item);
    if (index < 0 || index >= _visitables.get("tags").size()) { _visitables.get("tags").add(builder); } else { _visitables.get("tags").set(index, builder);}
    if (index < 0 || index >= tags.size()) { tags.add(builder); } else { tags.set(index, builder);}
     return (A)this;
  }
  public A addToTags(io.fabric8.openshift.api.model.NamedTagEventList... items) {
    if (this.tags == null) {this.tags = new java.util.ArrayList<io.fabric8.openshift.api.model.NamedTagEventListBuilder>();}
    for (io.fabric8.openshift.api.model.NamedTagEventList item : items) {io.fabric8.openshift.api.model.NamedTagEventListBuilder builder = new io.fabric8.openshift.api.model.NamedTagEventListBuilder(item);_visitables.get("tags").add(builder);this.tags.add(builder);} return (A)this;
  }
  public A addAllToTags(java.util.Collection<io.fabric8.openshift.api.model.NamedTagEventList> items) {
    if (this.tags == null) {this.tags = new java.util.ArrayList<io.fabric8.openshift.api.model.NamedTagEventListBuilder>();}
    for (io.fabric8.openshift.api.model.NamedTagEventList item : items) {io.fabric8.openshift.api.model.NamedTagEventListBuilder builder = new io.fabric8.openshift.api.model.NamedTagEventListBuilder(item);_visitables.get("tags").add(builder);this.tags.add(builder);} return (A)this;
  }
  public A removeFromTags(io.fabric8.openshift.api.model.NamedTagEventList... items) {
    for (io.fabric8.openshift.api.model.NamedTagEventList item : items) {io.fabric8.openshift.api.model.NamedTagEventListBuilder builder = new io.fabric8.openshift.api.model.NamedTagEventListBuilder(item);_visitables.get("tags").remove(builder);if (this.tags != null) {this.tags.remove(builder);}} return (A)this;
  }
  public A removeAllFromTags(java.util.Collection<io.fabric8.openshift.api.model.NamedTagEventList> items) {
    for (io.fabric8.openshift.api.model.NamedTagEventList item : items) {io.fabric8.openshift.api.model.NamedTagEventListBuilder builder = new io.fabric8.openshift.api.model.NamedTagEventListBuilder(item);_visitables.get("tags").remove(builder);if (this.tags != null) {this.tags.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromTags(java.util.function.Predicate<io.fabric8.openshift.api.model.NamedTagEventListBuilder> predicate) {
    if (tags == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.NamedTagEventListBuilder> each = tags.iterator();
    final List visitables = _visitables.get("tags");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.NamedTagEventListBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildTags instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.NamedTagEventList> getTags() {
    return build(tags);
  }
  public java.util.List<io.fabric8.openshift.api.model.NamedTagEventList> buildTags() {
    return build(tags);
  }
  public io.fabric8.openshift.api.model.NamedTagEventList buildTag(java.lang.Integer index) {
    return this.tags.get(index).build();
  }
  public io.fabric8.openshift.api.model.NamedTagEventList buildFirstTag() {
    return this.tags.get(0).build();
  }
  public io.fabric8.openshift.api.model.NamedTagEventList buildLastTag() {
    return this.tags.get(tags.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.NamedTagEventList buildMatchingTag(java.util.function.Predicate<io.fabric8.openshift.api.model.NamedTagEventListBuilder> predicate) {
    for (io.fabric8.openshift.api.model.NamedTagEventListBuilder item: tags) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingTag(java.util.function.Predicate<io.fabric8.openshift.api.model.NamedTagEventListBuilder> predicate) {
    for (io.fabric8.openshift.api.model.NamedTagEventListBuilder item: tags) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTags(java.util.List<io.fabric8.openshift.api.model.NamedTagEventList> tags) {
    if (this.tags != null) { _visitables.get("tags").removeAll(this.tags);}
    if (tags != null) {this.tags = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.NamedTagEventList item : tags){this.addToTags(item);}} else { this.tags = null;} return (A) this;
  }
  public A withTags(io.fabric8.openshift.api.model.NamedTagEventList... tags) {
    if (this.tags != null) {this.tags.clear();}
    if (tags != null) {for (io.fabric8.openshift.api.model.NamedTagEventList item :tags){ this.addToTags(item);}} return (A) this;
  }
  public java.lang.Boolean hasTags() {
    return tags != null && !tags.isEmpty();
  }
  public io.fabric8.openshift.api.model.ImageStreamStatusFluent.TagsNested<A> addNewTag() {
    return new io.fabric8.openshift.api.model.ImageStreamStatusFluentImpl.TagsNestedImpl();
  }
  public io.fabric8.openshift.api.model.ImageStreamStatusFluent.TagsNested<A> addNewTagLike(io.fabric8.openshift.api.model.NamedTagEventList item) {
    return new io.fabric8.openshift.api.model.ImageStreamStatusFluentImpl.TagsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.ImageStreamStatusFluent.TagsNested<A> setNewTagLike(java.lang.Integer index,io.fabric8.openshift.api.model.NamedTagEventList item) {
    return new io.fabric8.openshift.api.model.ImageStreamStatusFluentImpl.TagsNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.ImageStreamStatusFluent.TagsNested<A> editTag(java.lang.Integer index) {
    if (tags.size() <= index) throw new RuntimeException("Can't edit tags. Index exceeds size.");
    return setNewTagLike(index, buildTag(index));
  }
  public io.fabric8.openshift.api.model.ImageStreamStatusFluent.TagsNested<A> editFirstTag() {
    if (tags.size() == 0) throw new RuntimeException("Can't edit first tags. The list is empty.");
    return setNewTagLike(0, buildTag(0));
  }
  public io.fabric8.openshift.api.model.ImageStreamStatusFluent.TagsNested<A> editLastTag() {
    int index = tags.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last tags. The list is empty.");
    return setNewTagLike(index, buildTag(index));
  }
  public io.fabric8.openshift.api.model.ImageStreamStatusFluent.TagsNested<A> editMatchingTag(java.util.function.Predicate<io.fabric8.openshift.api.model.NamedTagEventListBuilder> predicate) {
    int index = -1;
    for (int i=0;i<tags.size();i++) { 
    if (predicate.test(tags.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching tags. No match found.");
    return setNewTagLike(index, buildTag(index));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ImageStreamStatusFluentImpl that = (ImageStreamStatusFluentImpl) o;
    if (dockerImageRepository != null ? !dockerImageRepository.equals(that.dockerImageRepository) :that.dockerImageRepository != null) return false;
    if (publicDockerImageRepository != null ? !publicDockerImageRepository.equals(that.publicDockerImageRepository) :that.publicDockerImageRepository != null) return false;
    if (tags != null ? !tags.equals(that.tags) :that.tags != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(dockerImageRepository,  publicDockerImageRepository,  tags,  additionalProperties,  super.hashCode());
  }
  public class TagsNestedImpl<N> extends io.fabric8.openshift.api.model.NamedTagEventListFluentImpl<io.fabric8.openshift.api.model.ImageStreamStatusFluent.TagsNested<N>> implements io.fabric8.openshift.api.model.ImageStreamStatusFluent.TagsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    TagsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.NamedTagEventList item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.NamedTagEventListBuilder(this, item);
    }
    TagsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.NamedTagEventListBuilder(this);
    }
    io.fabric8.openshift.api.model.NamedTagEventListBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ImageStreamStatusFluentImpl.this.setToTags(index,builder.build());
    }
    public N endTag() {
      return and();
    }
    
  }
  
}