package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AWSPlatformStatusBuilder extends AWSPlatformStatusFluentImpl<AWSPlatformStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<AWSPlatformStatus,AWSPlatformStatusBuilder> {

    AWSPlatformStatusFluent<?> fluent;
    Boolean validationEnabled;

    public AWSPlatformStatusBuilder() {
        this(true);
    }

    public AWSPlatformStatusBuilder(Boolean validationEnabled) {
        this(new AWSPlatformStatus(), validationEnabled);
    }

    public AWSPlatformStatusBuilder(AWSPlatformStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public AWSPlatformStatusBuilder(AWSPlatformStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new AWSPlatformStatus(), validationEnabled);
    }

    public AWSPlatformStatusBuilder(AWSPlatformStatusFluent<?> fluent,AWSPlatformStatus instance) {
        this(fluent, instance, true);
    }

    public AWSPlatformStatusBuilder(AWSPlatformStatusFluent<?> fluent,AWSPlatformStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withRegion(instance.getRegion()); 
        fluent.withServiceEndpoints(instance.getServiceEndpoints()); 
        this.validationEnabled = validationEnabled; 
    }

    public AWSPlatformStatusBuilder(AWSPlatformStatus instance) {
        this(instance,true);
    }

    public AWSPlatformStatusBuilder(AWSPlatformStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withRegion(instance.getRegion()); 
        this.withServiceEndpoints(instance.getServiceEndpoints()); 
        this.validationEnabled = validationEnabled; 
    }

    public AWSPlatformStatus build() {
        AWSPlatformStatus buildable = new AWSPlatformStatus(fluent.getRegion(),fluent.getServiceEndpoints());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        AWSPlatformStatusBuilder that = (AWSPlatformStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
