package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface BuildStatusFluent<A extends BuildStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public Boolean getCancelled();
    public A withCancelled(Boolean cancelled);
    public Boolean hasCancelled();
    public A withNewCancelled(String arg1);
    public A withNewCancelled(boolean arg1);
    public String getCompletionTimestamp();
    public A withCompletionTimestamp(String completionTimestamp);
    public Boolean hasCompletionTimestamp();
    public A withNewCompletionTimestamp(StringBuilder arg1);
    public A withNewCompletionTimestamp(int[] arg1,int arg2,int arg3);
    public A withNewCompletionTimestamp(char[] arg1);
    public A withNewCompletionTimestamp(StringBuffer arg1);
    public A withNewCompletionTimestamp(byte[] arg1,int arg2);
    public A withNewCompletionTimestamp(byte[] arg1);
    public A withNewCompletionTimestamp(char[] arg1,int arg2,int arg3);
    public A withNewCompletionTimestamp(byte[] arg1,int arg2,int arg3);
    public A withNewCompletionTimestamp(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewCompletionTimestamp(String arg1);
    public A addToConditions(int index,BuildCondition item);
    public A setToConditions(int index,BuildCondition item);
    public A addToConditions(BuildCondition... items);
    public A addAllToConditions(Collection<BuildCondition> items);
    public A removeFromConditions(BuildCondition... items);
    public A removeAllFromConditions(Collection<BuildCondition> items);
    public A removeMatchingFromConditions(Predicate<BuildConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<BuildCondition> getConditions();
    public List<BuildCondition> buildConditions();
    public BuildCondition buildCondition(int index);
    public BuildCondition buildFirstCondition();
    public BuildCondition buildLastCondition();
    public BuildCondition buildMatchingCondition(Predicate<BuildConditionBuilder> predicate);
    public Boolean hasMatchingCondition(Predicate<BuildConditionBuilder> predicate);
    public A withConditions(List<BuildCondition> conditions);
    public A withConditions(BuildCondition... conditions);
    public Boolean hasConditions();
    public io.fabric8.openshift.api.model.BuildStatusFluent.ConditionsNested<A> addNewCondition();
    public io.fabric8.openshift.api.model.BuildStatusFluent.ConditionsNested<A> addNewConditionLike(BuildCondition item);
    public io.fabric8.openshift.api.model.BuildStatusFluent.ConditionsNested<A> setNewConditionLike(int index,BuildCondition item);
    public io.fabric8.openshift.api.model.BuildStatusFluent.ConditionsNested<A> editCondition(int index);
    public io.fabric8.openshift.api.model.BuildStatusFluent.ConditionsNested<A> editFirstCondition();
    public io.fabric8.openshift.api.model.BuildStatusFluent.ConditionsNested<A> editLastCondition();
    public io.fabric8.openshift.api.model.BuildStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<BuildConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConfig instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.kubernetes.api.model.ObjectReference getConfig();
    public io.fabric8.kubernetes.api.model.ObjectReference buildConfig();
    public A withConfig(io.fabric8.kubernetes.api.model.ObjectReference config);
    public Boolean hasConfig();
    public io.fabric8.openshift.api.model.BuildStatusFluent.ConfigNested<A> withNewConfig();
    public io.fabric8.openshift.api.model.BuildStatusFluent.ConfigNested<A> withNewConfigLike(io.fabric8.kubernetes.api.model.ObjectReference item);
    public io.fabric8.openshift.api.model.BuildStatusFluent.ConfigNested<A> editConfig();
    public io.fabric8.openshift.api.model.BuildStatusFluent.ConfigNested<A> editOrNewConfig();
    public io.fabric8.openshift.api.model.BuildStatusFluent.ConfigNested<A> editOrNewConfigLike(io.fabric8.kubernetes.api.model.ObjectReference item);
    public Long getDuration();
    public A withDuration(Long duration);
    public Boolean hasDuration();
    public A withNewDuration(long arg1);
    public String getLogSnippet();
    public A withLogSnippet(String logSnippet);
    public Boolean hasLogSnippet();
    public A withNewLogSnippet(StringBuilder arg1);
    public A withNewLogSnippet(int[] arg1,int arg2,int arg3);
    public A withNewLogSnippet(char[] arg1);
    public A withNewLogSnippet(StringBuffer arg1);
    public A withNewLogSnippet(byte[] arg1,int arg2);
    public A withNewLogSnippet(byte[] arg1);
    public A withNewLogSnippet(char[] arg1,int arg2,int arg3);
    public A withNewLogSnippet(byte[] arg1,int arg2,int arg3);
    public A withNewLogSnippet(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewLogSnippet(String arg1);
    public String getMessage();
    public A withMessage(String message);
    public Boolean hasMessage();
    public A withNewMessage(StringBuilder arg1);
    public A withNewMessage(int[] arg1,int arg2,int arg3);
    public A withNewMessage(char[] arg1);
    public A withNewMessage(StringBuffer arg1);
    public A withNewMessage(byte[] arg1,int arg2);
    public A withNewMessage(byte[] arg1);
    public A withNewMessage(char[] arg1,int arg2,int arg3);
    public A withNewMessage(byte[] arg1,int arg2,int arg3);
    public A withNewMessage(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewMessage(String arg1);
    
/**
 * This method has been deprecated, please use method buildOutput instead.
 * @return The buildable object.
 */
@Deprecated public BuildStatusOutput getOutput();
    public BuildStatusOutput buildOutput();
    public A withOutput(BuildStatusOutput output);
    public Boolean hasOutput();
    public io.fabric8.openshift.api.model.BuildStatusFluent.OutputNested<A> withNewOutput();
    public io.fabric8.openshift.api.model.BuildStatusFluent.OutputNested<A> withNewOutputLike(BuildStatusOutput item);
    public io.fabric8.openshift.api.model.BuildStatusFluent.OutputNested<A> editOutput();
    public io.fabric8.openshift.api.model.BuildStatusFluent.OutputNested<A> editOrNewOutput();
    public io.fabric8.openshift.api.model.BuildStatusFluent.OutputNested<A> editOrNewOutputLike(BuildStatusOutput item);
    public String getOutputDockerImageReference();
    public A withOutputDockerImageReference(String outputDockerImageReference);
    public Boolean hasOutputDockerImageReference();
    public A withNewOutputDockerImageReference(StringBuilder arg1);
    public A withNewOutputDockerImageReference(int[] arg1,int arg2,int arg3);
    public A withNewOutputDockerImageReference(char[] arg1);
    public A withNewOutputDockerImageReference(StringBuffer arg1);
    public A withNewOutputDockerImageReference(byte[] arg1,int arg2);
    public A withNewOutputDockerImageReference(byte[] arg1);
    public A withNewOutputDockerImageReference(char[] arg1,int arg2,int arg3);
    public A withNewOutputDockerImageReference(byte[] arg1,int arg2,int arg3);
    public A withNewOutputDockerImageReference(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewOutputDockerImageReference(String arg1);
    public String getPhase();
    public A withPhase(String phase);
    public Boolean hasPhase();
    public A withNewPhase(StringBuilder arg1);
    public A withNewPhase(int[] arg1,int arg2,int arg3);
    public A withNewPhase(char[] arg1);
    public A withNewPhase(StringBuffer arg1);
    public A withNewPhase(byte[] arg1,int arg2);
    public A withNewPhase(byte[] arg1);
    public A withNewPhase(char[] arg1,int arg2,int arg3);
    public A withNewPhase(byte[] arg1,int arg2,int arg3);
    public A withNewPhase(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewPhase(String arg1);
    public String getReason();
    public A withReason(String reason);
    public Boolean hasReason();
    public A withNewReason(StringBuilder arg1);
    public A withNewReason(int[] arg1,int arg2,int arg3);
    public A withNewReason(char[] arg1);
    public A withNewReason(StringBuffer arg1);
    public A withNewReason(byte[] arg1,int arg2);
    public A withNewReason(byte[] arg1);
    public A withNewReason(char[] arg1,int arg2,int arg3);
    public A withNewReason(byte[] arg1,int arg2,int arg3);
    public A withNewReason(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewReason(String arg1);
    public A addToStages(int index,StageInfo item);
    public A setToStages(int index,StageInfo item);
    public A addToStages(StageInfo... items);
    public A addAllToStages(Collection<StageInfo> items);
    public A removeFromStages(StageInfo... items);
    public A removeAllFromStages(Collection<StageInfo> items);
    public A removeMatchingFromStages(Predicate<StageInfoBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildStages instead.
 * @return The buildable object.
 */
@Deprecated public List<StageInfo> getStages();
    public List<StageInfo> buildStages();
    public StageInfo buildStage(int index);
    public StageInfo buildFirstStage();
    public StageInfo buildLastStage();
    public StageInfo buildMatchingStage(Predicate<StageInfoBuilder> predicate);
    public Boolean hasMatchingStage(Predicate<StageInfoBuilder> predicate);
    public A withStages(List<StageInfo> stages);
    public A withStages(StageInfo... stages);
    public Boolean hasStages();
    public io.fabric8.openshift.api.model.BuildStatusFluent.StagesNested<A> addNewStage();
    public io.fabric8.openshift.api.model.BuildStatusFluent.StagesNested<A> addNewStageLike(StageInfo item);
    public io.fabric8.openshift.api.model.BuildStatusFluent.StagesNested<A> setNewStageLike(int index,StageInfo item);
    public io.fabric8.openshift.api.model.BuildStatusFluent.StagesNested<A> editStage(int index);
    public io.fabric8.openshift.api.model.BuildStatusFluent.StagesNested<A> editFirstStage();
    public io.fabric8.openshift.api.model.BuildStatusFluent.StagesNested<A> editLastStage();
    public io.fabric8.openshift.api.model.BuildStatusFluent.StagesNested<A> editMatchingStage(Predicate<StageInfoBuilder> predicate);
    public String getStartTimestamp();
    public A withStartTimestamp(String startTimestamp);
    public Boolean hasStartTimestamp();
    public A withNewStartTimestamp(StringBuilder arg1);
    public A withNewStartTimestamp(int[] arg1,int arg2,int arg3);
    public A withNewStartTimestamp(char[] arg1);
    public A withNewStartTimestamp(StringBuffer arg1);
    public A withNewStartTimestamp(byte[] arg1,int arg2);
    public A withNewStartTimestamp(byte[] arg1);
    public A withNewStartTimestamp(char[] arg1,int arg2,int arg3);
    public A withNewStartTimestamp(byte[] arg1,int arg2,int arg3);
    public A withNewStartTimestamp(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewStartTimestamp(String arg1);
    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildConditionFluent<io.fabric8.openshift.api.model.BuildStatusFluent.ConditionsNested<N>> {

            public N and();
            public N endCondition();    }


    public interface ConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectReferenceFluent<io.fabric8.openshift.api.model.BuildStatusFluent.ConfigNested<N>> {

            public N and();
            public N endConfig();    }


    public interface OutputNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildStatusOutputFluent<io.fabric8.openshift.api.model.BuildStatusFluent.OutputNested<N>> {

            public N and();
            public N endOutput();    }


    public interface StagesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,StageInfoFluent<io.fabric8.openshift.api.model.BuildStatusFluent.StagesNested<N>> {

            public N and();
            public N endStage();    }


}
