package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class BuildStatusOutputBuilder extends BuildStatusOutputFluentImpl<BuildStatusOutputBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<BuildStatusOutput,BuildStatusOutputBuilder> {

    BuildStatusOutputFluent<?> fluent;
    Boolean validationEnabled;

    public BuildStatusOutputBuilder() {
        this(true);
    }

    public BuildStatusOutputBuilder(Boolean validationEnabled) {
        this(new BuildStatusOutput(), validationEnabled);
    }

    public BuildStatusOutputBuilder(BuildStatusOutputFluent<?> fluent) {
        this(fluent, true);
    }

    public BuildStatusOutputBuilder(BuildStatusOutputFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new BuildStatusOutput(), validationEnabled);
    }

    public BuildStatusOutputBuilder(BuildStatusOutputFluent<?> fluent,BuildStatusOutput instance) {
        this(fluent, instance, true);
    }

    public BuildStatusOutputBuilder(BuildStatusOutputFluent<?> fluent,BuildStatusOutput instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withTo(instance.getTo()); 
        this.validationEnabled = validationEnabled; 
    }

    public BuildStatusOutputBuilder(BuildStatusOutput instance) {
        this(instance,true);
    }

    public BuildStatusOutputBuilder(BuildStatusOutput instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withTo(instance.getTo()); 
        this.validationEnabled = validationEnabled; 
    }

    public BuildStatusOutput build() {
        BuildStatusOutput buildable = new BuildStatusOutput(fluent.getTo());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        BuildStatusOutputBuilder that = (BuildStatusOutputBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
