package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ClusterResourceQuotaSelectorBuilder extends ClusterResourceQuotaSelectorFluentImpl<ClusterResourceQuotaSelectorBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<ClusterResourceQuotaSelector,ClusterResourceQuotaSelectorBuilder> {

    ClusterResourceQuotaSelectorFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterResourceQuotaSelectorBuilder() {
        this(true);
    }

    public ClusterResourceQuotaSelectorBuilder(Boolean validationEnabled) {
        this(new ClusterResourceQuotaSelector(), validationEnabled);
    }

    public ClusterResourceQuotaSelectorBuilder(ClusterResourceQuotaSelectorFluent<?> fluent) {
        this(fluent, true);
    }

    public ClusterResourceQuotaSelectorBuilder(ClusterResourceQuotaSelectorFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ClusterResourceQuotaSelector(), validationEnabled);
    }

    public ClusterResourceQuotaSelectorBuilder(ClusterResourceQuotaSelectorFluent<?> fluent,ClusterResourceQuotaSelector instance) {
        this(fluent, instance, true);
    }

    public ClusterResourceQuotaSelectorBuilder(ClusterResourceQuotaSelectorFluent<?> fluent,ClusterResourceQuotaSelector instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAnnotations(instance.getAnnotations()); 
        fluent.withLabels(instance.getLabels()); 
        this.validationEnabled = validationEnabled; 
    }

    public ClusterResourceQuotaSelectorBuilder(ClusterResourceQuotaSelector instance) {
        this(instance,true);
    }

    public ClusterResourceQuotaSelectorBuilder(ClusterResourceQuotaSelector instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAnnotations(instance.getAnnotations()); 
        this.withLabels(instance.getLabels()); 
        this.validationEnabled = validationEnabled; 
    }

    public ClusterResourceQuotaSelector build() {
        ClusterResourceQuotaSelector buildable = new ClusterResourceQuotaSelector(fluent.getAnnotations(),fluent.getLabels());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ClusterResourceQuotaSelectorBuilder that = (ClusterResourceQuotaSelectorBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
