package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DNSZoneBuilder extends DNSZoneFluentImpl<DNSZoneBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<DNSZone,DNSZoneBuilder> {

    DNSZoneFluent<?> fluent;
    Boolean validationEnabled;

    public DNSZoneBuilder() {
        this(true);
    }

    public DNSZoneBuilder(Boolean validationEnabled) {
        this(new DNSZone(), validationEnabled);
    }

    public DNSZoneBuilder(DNSZoneFluent<?> fluent) {
        this(fluent, true);
    }

    public DNSZoneBuilder(DNSZoneFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new DNSZone(), validationEnabled);
    }

    public DNSZoneBuilder(DNSZoneFluent<?> fluent,DNSZone instance) {
        this(fluent, instance, true);
    }

    public DNSZoneBuilder(DNSZoneFluent<?> fluent,DNSZone instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withId(instance.getId()); 
        fluent.withTags(instance.getTags()); 
        this.validationEnabled = validationEnabled; 
    }

    public DNSZoneBuilder(DNSZone instance) {
        this(instance,true);
    }

    public DNSZoneBuilder(DNSZone instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withId(instance.getId()); 
        this.withTags(instance.getTags()); 
        this.validationEnabled = validationEnabled; 
    }

    public DNSZone build() {
        DNSZone buildable = new DNSZone(fluent.getId(),fluent.getTags());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        DNSZoneBuilder that = (DNSZoneBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
