package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ExecNewPodHookFluent<A extends ExecNewPodHookFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public A addToCommand(int index,String item);
    public A setToCommand(int index,String item);
    public A addToCommand(String... items);
    public A addAllToCommand(Collection<String> items);
    public A removeFromCommand(String... items);
    public A removeAllFromCommand(Collection<String> items);
    public List<String> getCommand();
    public String getCommand(int index);
    public String getFirstCommand();
    public String getLastCommand();
    public String getMatchingCommand(Predicate<String> predicate);
    public Boolean hasMatchingCommand(Predicate<String> predicate);
    public A withCommand(List<String> command);
    public A withCommand(String... command);
    public Boolean hasCommand();
    public A addNewCommand(StringBuilder arg1);
    public A addNewCommand(int[] arg1,int arg2,int arg3);
    public A addNewCommand(char[] arg1);
    public A addNewCommand(StringBuffer arg1);
    public A addNewCommand(byte[] arg1,int arg2);
    public A addNewCommand(byte[] arg1);
    public A addNewCommand(char[] arg1,int arg2,int arg3);
    public A addNewCommand(byte[] arg1,int arg2,int arg3);
    public A addNewCommand(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewCommand(String arg1);
    public String getContainerName();
    public A withContainerName(String containerName);
    public Boolean hasContainerName();
    public A withNewContainerName(StringBuilder arg1);
    public A withNewContainerName(int[] arg1,int arg2,int arg3);
    public A withNewContainerName(char[] arg1);
    public A withNewContainerName(StringBuffer arg1);
    public A withNewContainerName(byte[] arg1,int arg2);
    public A withNewContainerName(byte[] arg1);
    public A withNewContainerName(char[] arg1,int arg2,int arg3);
    public A withNewContainerName(byte[] arg1,int arg2,int arg3);
    public A withNewContainerName(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewContainerName(String arg1);
    public A addToEnv(int index,EnvVar item);
    public A setToEnv(int index,EnvVar item);
    public A addToEnv(EnvVar... items);
    public A addAllToEnv(Collection<EnvVar> items);
    public A removeFromEnv(EnvVar... items);
    public A removeAllFromEnv(Collection<EnvVar> items);
    public List<EnvVar> getEnv();
    public EnvVar getEnv(int index);
    public EnvVar getFirstEnv();
    public EnvVar getLastEnv();
    public EnvVar getMatchingEnv(Predicate<EnvVar> predicate);
    public Boolean hasMatchingEnv(Predicate<EnvVar> predicate);
    public A withEnv(List<EnvVar> env);
    public A withEnv(EnvVar... env);
    public Boolean hasEnv();
    public A addToVolumes(int index,String item);
    public A setToVolumes(int index,String item);
    public A addToVolumes(String... items);
    public A addAllToVolumes(Collection<String> items);
    public A removeFromVolumes(String... items);
    public A removeAllFromVolumes(Collection<String> items);
    public List<String> getVolumes();
    public String getVolume(int index);
    public String getFirstVolume();
    public String getLastVolume();
    public String getMatchingVolume(Predicate<String> predicate);
    public Boolean hasMatchingVolume(Predicate<String> predicate);
    public A withVolumes(List<String> volumes);
    public A withVolumes(String... volumes);
    public Boolean hasVolumes();
    public A addNewVolume(StringBuilder arg1);
    public A addNewVolume(int[] arg1,int arg2,int arg3);
    public A addNewVolume(char[] arg1);
    public A addNewVolume(StringBuffer arg1);
    public A addNewVolume(byte[] arg1,int arg2);
    public A addNewVolume(byte[] arg1);
    public A addNewVolume(char[] arg1,int arg2,int arg3);
    public A addNewVolume(byte[] arg1,int arg2,int arg3);
    public A addNewVolume(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewVolume(String arg1);
}
