package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class GCPPlatformSpecBuilder extends GCPPlatformSpecFluentImpl<GCPPlatformSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<GCPPlatformSpec,GCPPlatformSpecBuilder> {

    GCPPlatformSpecFluent<?> fluent;
    Boolean validationEnabled;

    public GCPPlatformSpecBuilder() {
        this(true);
    }

    public GCPPlatformSpecBuilder(Boolean validationEnabled) {
        this(new GCPPlatformSpec(), validationEnabled);
    }

    public GCPPlatformSpecBuilder(GCPPlatformSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public GCPPlatformSpecBuilder(GCPPlatformSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new GCPPlatformSpec(), validationEnabled);
    }

    public GCPPlatformSpecBuilder(GCPPlatformSpecFluent<?> fluent,GCPPlatformSpec instance) {
        this(fluent, instance, true);
    }

    public GCPPlatformSpecBuilder(GCPPlatformSpecFluent<?> fluent,GCPPlatformSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        this.validationEnabled = validationEnabled; 
    }

    public GCPPlatformSpecBuilder(GCPPlatformSpec instance) {
        this(instance,true);
    }

    public GCPPlatformSpecBuilder(GCPPlatformSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.validationEnabled = validationEnabled; 
    }

    public GCPPlatformSpec build() {
        GCPPlatformSpec buildable = new GCPPlatformSpec();
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        GCPPlatformSpecBuilder that = (GCPPlatformSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
