package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OAuthStatusBuilder extends OAuthStatusFluentImpl<OAuthStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<OAuthStatus,OAuthStatusBuilder> {

    OAuthStatusFluent<?> fluent;
    Boolean validationEnabled;

    public OAuthStatusBuilder() {
        this(true);
    }

    public OAuthStatusBuilder(Boolean validationEnabled) {
        this(new OAuthStatus(), validationEnabled);
    }

    public OAuthStatusBuilder(OAuthStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public OAuthStatusBuilder(OAuthStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new OAuthStatus(), validationEnabled);
    }

    public OAuthStatusBuilder(OAuthStatusFluent<?> fluent,OAuthStatus instance) {
        this(fluent, instance, true);
    }

    public OAuthStatusBuilder(OAuthStatusFluent<?> fluent,OAuthStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        this.validationEnabled = validationEnabled; 
    }

    public OAuthStatusBuilder(OAuthStatus instance) {
        this(instance,true);
    }

    public OAuthStatusBuilder(OAuthStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.validationEnabled = validationEnabled; 
    }

    public OAuthStatus build() {
        OAuthStatus buildable = new OAuthStatus();
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        OAuthStatusBuilder that = (OAuthStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
