package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ReleaseFluent<A extends ReleaseFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public A addToChannels(int index,String item);
    public A setToChannels(int index,String item);
    public A addToChannels(String... items);
    public A addAllToChannels(Collection<String> items);
    public A removeFromChannels(String... items);
    public A removeAllFromChannels(Collection<String> items);
    public List<String> getChannels();
    public String getChannel(int index);
    public String getFirstChannel();
    public String getLastChannel();
    public String getMatchingChannel(Predicate<String> predicate);
    public Boolean hasMatchingChannel(Predicate<String> predicate);
    public A withChannels(List<String> channels);
    public A withChannels(String... channels);
    public Boolean hasChannels();
    public A addNewChannel(StringBuilder arg1);
    public A addNewChannel(int[] arg1,int arg2,int arg3);
    public A addNewChannel(char[] arg1);
    public A addNewChannel(StringBuffer arg1);
    public A addNewChannel(byte[] arg1,int arg2);
    public A addNewChannel(byte[] arg1);
    public A addNewChannel(char[] arg1,int arg2,int arg3);
    public A addNewChannel(byte[] arg1,int arg2,int arg3);
    public A addNewChannel(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewChannel(String arg1);
    public String getImage();
    public A withImage(String image);
    public Boolean hasImage();
    public A withNewImage(StringBuilder arg1);
    public A withNewImage(int[] arg1,int arg2,int arg3);
    public A withNewImage(char[] arg1);
    public A withNewImage(StringBuffer arg1);
    public A withNewImage(byte[] arg1,int arg2);
    public A withNewImage(byte[] arg1);
    public A withNewImage(char[] arg1,int arg2,int arg3);
    public A withNewImage(byte[] arg1,int arg2,int arg3);
    public A withNewImage(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewImage(String arg1);
    public String getUrl();
    public A withUrl(String url);
    public Boolean hasUrl();
    public A withNewUrl(StringBuilder arg1);
    public A withNewUrl(int[] arg1,int arg2,int arg3);
    public A withNewUrl(char[] arg1);
    public A withNewUrl(StringBuffer arg1);
    public A withNewUrl(byte[] arg1,int arg2);
    public A withNewUrl(byte[] arg1);
    public A withNewUrl(char[] arg1,int arg2,int arg3);
    public A withNewUrl(byte[] arg1,int arg2,int arg3);
    public A withNewUrl(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewUrl(String arg1);
    public String getVersion();
    public A withVersion(String version);
    public Boolean hasVersion();
    public A withNewVersion(StringBuilder arg1);
    public A withNewVersion(int[] arg1,int arg2,int arg3);
    public A withNewVersion(char[] arg1);
    public A withNewVersion(StringBuffer arg1);
    public A withNewVersion(byte[] arg1,int arg2);
    public A withNewVersion(byte[] arg1);
    public A withNewVersion(char[] arg1,int arg2,int arg3);
    public A withNewVersion(byte[] arg1,int arg2,int arg3);
    public A withNewVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewVersion(String arg1);
}
