package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface RoleBindingFluent<A extends RoleBindingFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(int[] arg1,int arg2,int arg3);
    public A withNewApiVersion(char[] arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A withNewApiVersion(byte[] arg1,int arg2);
    public A withNewApiVersion(byte[] arg1);
    public A withNewApiVersion(char[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewApiVersion(String arg1);
    public A addToGroupNames(int index,String item);
    public A setToGroupNames(int index,String item);
    public A addToGroupNames(String... items);
    public A addAllToGroupNames(Collection<String> items);
    public A removeFromGroupNames(String... items);
    public A removeAllFromGroupNames(Collection<String> items);
    public List<String> getGroupNames();
    public String getGroupName(int index);
    public String getFirstGroupName();
    public String getLastGroupName();
    public String getMatchingGroupName(Predicate<String> predicate);
    public Boolean hasMatchingGroupName(Predicate<String> predicate);
    public A withGroupNames(List<String> groupNames);
    public A withGroupNames(String... groupNames);
    public Boolean hasGroupNames();
    public A addNewGroupName(StringBuilder arg1);
    public A addNewGroupName(int[] arg1,int arg2,int arg3);
    public A addNewGroupName(char[] arg1);
    public A addNewGroupName(StringBuffer arg1);
    public A addNewGroupName(byte[] arg1,int arg2);
    public A addNewGroupName(byte[] arg1);
    public A addNewGroupName(char[] arg1,int arg2,int arg3);
    public A addNewGroupName(byte[] arg1,int arg2,int arg3);
    public A addNewGroupName(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewGroupName(String arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(int[] arg1,int arg2,int arg3);
    public A withNewKind(char[] arg1);
    public A withNewKind(StringBuffer arg1);
    public A withNewKind(byte[] arg1,int arg2);
    public A withNewKind(byte[] arg1);
    public A withNewKind(char[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewKind(String arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public io.fabric8.openshift.api.model.RoleBindingFluent.MetadataNested<A> withNewMetadata();
    public io.fabric8.openshift.api.model.RoleBindingFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public io.fabric8.openshift.api.model.RoleBindingFluent.MetadataNested<A> editMetadata();
    public io.fabric8.openshift.api.model.RoleBindingFluent.MetadataNested<A> editOrNewMetadata();
    public io.fabric8.openshift.api.model.RoleBindingFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildRoleRef instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.kubernetes.api.model.ObjectReference getRoleRef();
    public io.fabric8.kubernetes.api.model.ObjectReference buildRoleRef();
    public A withRoleRef(io.fabric8.kubernetes.api.model.ObjectReference roleRef);
    public Boolean hasRoleRef();
    public io.fabric8.openshift.api.model.RoleBindingFluent.RoleRefNested<A> withNewRoleRef();
    public io.fabric8.openshift.api.model.RoleBindingFluent.RoleRefNested<A> withNewRoleRefLike(io.fabric8.kubernetes.api.model.ObjectReference item);
    public io.fabric8.openshift.api.model.RoleBindingFluent.RoleRefNested<A> editRoleRef();
    public io.fabric8.openshift.api.model.RoleBindingFluent.RoleRefNested<A> editOrNewRoleRef();
    public io.fabric8.openshift.api.model.RoleBindingFluent.RoleRefNested<A> editOrNewRoleRefLike(io.fabric8.kubernetes.api.model.ObjectReference item);
    public A addToSubjects(int index,io.fabric8.kubernetes.api.model.ObjectReference item);
    public A setToSubjects(int index,io.fabric8.kubernetes.api.model.ObjectReference item);
    public A addToSubjects(io.fabric8.kubernetes.api.model.ObjectReference... items);
    public A addAllToSubjects(Collection<io.fabric8.kubernetes.api.model.ObjectReference> items);
    public A removeFromSubjects(io.fabric8.kubernetes.api.model.ObjectReference... items);
    public A removeAllFromSubjects(Collection<io.fabric8.kubernetes.api.model.ObjectReference> items);
    public A removeMatchingFromSubjects(Predicate<ObjectReferenceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildSubjects instead.
 * @return The buildable object.
 */
@Deprecated public List<io.fabric8.kubernetes.api.model.ObjectReference> getSubjects();
    public List<io.fabric8.kubernetes.api.model.ObjectReference> buildSubjects();
    public io.fabric8.kubernetes.api.model.ObjectReference buildSubject(int index);
    public io.fabric8.kubernetes.api.model.ObjectReference buildFirstSubject();
    public io.fabric8.kubernetes.api.model.ObjectReference buildLastSubject();
    public io.fabric8.kubernetes.api.model.ObjectReference buildMatchingSubject(Predicate<ObjectReferenceBuilder> predicate);
    public Boolean hasMatchingSubject(Predicate<ObjectReferenceBuilder> predicate);
    public A withSubjects(List<io.fabric8.kubernetes.api.model.ObjectReference> subjects);
    public A withSubjects(io.fabric8.kubernetes.api.model.ObjectReference... subjects);
    public Boolean hasSubjects();
    public io.fabric8.openshift.api.model.RoleBindingFluent.SubjectsNested<A> addNewSubject();
    public io.fabric8.openshift.api.model.RoleBindingFluent.SubjectsNested<A> addNewSubjectLike(io.fabric8.kubernetes.api.model.ObjectReference item);
    public io.fabric8.openshift.api.model.RoleBindingFluent.SubjectsNested<A> setNewSubjectLike(int index,io.fabric8.kubernetes.api.model.ObjectReference item);
    public io.fabric8.openshift.api.model.RoleBindingFluent.SubjectsNested<A> editSubject(int index);
    public io.fabric8.openshift.api.model.RoleBindingFluent.SubjectsNested<A> editFirstSubject();
    public io.fabric8.openshift.api.model.RoleBindingFluent.SubjectsNested<A> editLastSubject();
    public io.fabric8.openshift.api.model.RoleBindingFluent.SubjectsNested<A> editMatchingSubject(Predicate<ObjectReferenceBuilder> predicate);
    public A addToUserNames(int index,String item);
    public A setToUserNames(int index,String item);
    public A addToUserNames(String... items);
    public A addAllToUserNames(Collection<String> items);
    public A removeFromUserNames(String... items);
    public A removeAllFromUserNames(Collection<String> items);
    public List<String> getUserNames();
    public String getUserName(int index);
    public String getFirstUserName();
    public String getLastUserName();
    public String getMatchingUserName(Predicate<String> predicate);
    public Boolean hasMatchingUserName(Predicate<String> predicate);
    public A withUserNames(List<String> userNames);
    public A withUserNames(String... userNames);
    public Boolean hasUserNames();
    public A addNewUserName(StringBuilder arg1);
    public A addNewUserName(int[] arg1,int arg2,int arg3);
    public A addNewUserName(char[] arg1);
    public A addNewUserName(StringBuffer arg1);
    public A addNewUserName(byte[] arg1,int arg2);
    public A addNewUserName(byte[] arg1);
    public A addNewUserName(char[] arg1,int arg2,int arg3);
    public A addNewUserName(byte[] arg1,int arg2,int arg3);
    public A addNewUserName(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewUserName(String arg1);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<io.fabric8.openshift.api.model.RoleBindingFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


    public interface RoleRefNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectReferenceFluent<io.fabric8.openshift.api.model.RoleBindingFluent.RoleRefNested<N>> {

            public N and();
            public N endRoleRef();    }


    public interface SubjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectReferenceFluent<io.fabric8.openshift.api.model.RoleBindingFluent.SubjectsNested<N>> {

            public N and();
            public N endSubject();    }


}
