package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class SchedulerSpecFluentImpl<A extends SchedulerSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SchedulerSpecFluent<A> {

    private String defaultNodeSelector;
    private Boolean mastersSchedulable;
    private ConfigMapNameReferenceBuilder policy;

    public SchedulerSpecFluentImpl() {
    }

    public SchedulerSpecFluentImpl(SchedulerSpec instance) {
        this.withDefaultNodeSelector(instance.getDefaultNodeSelector()); 
        this.withMastersSchedulable(instance.getMastersSchedulable()); 
        this.withPolicy(instance.getPolicy()); 
    }

    public String getDefaultNodeSelector() {
        return this.defaultNodeSelector;
    }

    public A withDefaultNodeSelector(String defaultNodeSelector) {
        this.defaultNodeSelector=defaultNodeSelector; return (A) this;
    }

    public Boolean hasDefaultNodeSelector() {
        return this.defaultNodeSelector != null;
    }

    public A withNewDefaultNodeSelector(StringBuilder arg1) {
        return (A)withDefaultNodeSelector(new String(arg1));
    }

    public A withNewDefaultNodeSelector(int[] arg1,int arg2,int arg3) {
        return (A)withDefaultNodeSelector(new String(arg1, arg2, arg3));
    }

    public A withNewDefaultNodeSelector(char[] arg1) {
        return (A)withDefaultNodeSelector(new String(arg1));
    }

    public A withNewDefaultNodeSelector(StringBuffer arg1) {
        return (A)withDefaultNodeSelector(new String(arg1));
    }

    public A withNewDefaultNodeSelector(byte[] arg1,int arg2) {
        return (A)withDefaultNodeSelector(new String(arg1, arg2));
    }

    public A withNewDefaultNodeSelector(byte[] arg1) {
        return (A)withDefaultNodeSelector(new String(arg1));
    }

    public A withNewDefaultNodeSelector(char[] arg1,int arg2,int arg3) {
        return (A)withDefaultNodeSelector(new String(arg1, arg2, arg3));
    }

    public A withNewDefaultNodeSelector(byte[] arg1,int arg2,int arg3) {
        return (A)withDefaultNodeSelector(new String(arg1, arg2, arg3));
    }

    public A withNewDefaultNodeSelector(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withDefaultNodeSelector(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewDefaultNodeSelector(String arg1) {
        return (A)withDefaultNodeSelector(new String(arg1));
    }

    public Boolean getMastersSchedulable() {
        return this.mastersSchedulable;
    }

    public A withMastersSchedulable(Boolean mastersSchedulable) {
        this.mastersSchedulable=mastersSchedulable; return (A) this;
    }

    public Boolean hasMastersSchedulable() {
        return this.mastersSchedulable != null;
    }

    public A withNewMastersSchedulable(String arg1) {
        return (A)withMastersSchedulable(new Boolean(arg1));
    }

    public A withNewMastersSchedulable(boolean arg1) {
        return (A)withMastersSchedulable(new Boolean(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildPolicy instead.
 * @return The buildable object.
 */
@Deprecated public ConfigMapNameReference getPolicy() {
        return this.policy!=null?this.policy.build():null;
    }

    public ConfigMapNameReference buildPolicy() {
        return this.policy!=null?this.policy.build():null;
    }

    public A withPolicy(ConfigMapNameReference policy) {
        _visitables.get("policy").remove(this.policy);
        if (policy!=null){ this.policy= new ConfigMapNameReferenceBuilder(policy); _visitables.get("policy").add(this.policy);} return (A) this;
    }

    public Boolean hasPolicy() {
        return this.policy != null;
    }

    public A withNewPolicy(String name) {
        return (A)withPolicy(new ConfigMapNameReference(name));
    }

    public io.fabric8.openshift.api.model.SchedulerSpecFluent.PolicyNested<A> withNewPolicy() {
        return new PolicyNestedImpl();
    }

    public io.fabric8.openshift.api.model.SchedulerSpecFluent.PolicyNested<A> withNewPolicyLike(ConfigMapNameReference item) {
        return new PolicyNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.SchedulerSpecFluent.PolicyNested<A> editPolicy() {
        return withNewPolicyLike(getPolicy());
    }

    public io.fabric8.openshift.api.model.SchedulerSpecFluent.PolicyNested<A> editOrNewPolicy() {
        return withNewPolicyLike(getPolicy() != null ? getPolicy(): new ConfigMapNameReferenceBuilder().build());
    }

    public io.fabric8.openshift.api.model.SchedulerSpecFluent.PolicyNested<A> editOrNewPolicyLike(ConfigMapNameReference item) {
        return withNewPolicyLike(getPolicy() != null ? getPolicy(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SchedulerSpecFluentImpl that = (SchedulerSpecFluentImpl) o;
        if (defaultNodeSelector != null ? !defaultNodeSelector.equals(that.defaultNodeSelector) :that.defaultNodeSelector != null) return false;
        if (mastersSchedulable != null ? !mastersSchedulable.equals(that.mastersSchedulable) :that.mastersSchedulable != null) return false;
        if (policy != null ? !policy.equals(that.policy) :that.policy != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(defaultNodeSelector,  mastersSchedulable,  policy,  super.hashCode());
    }

    public class PolicyNestedImpl<N> extends ConfigMapNameReferenceFluentImpl<io.fabric8.openshift.api.model.SchedulerSpecFluent.PolicyNested<N>> implements io.fabric8.openshift.api.model.SchedulerSpecFluent.PolicyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ConfigMapNameReferenceBuilder builder;

            PolicyNestedImpl(ConfigMapNameReference item) {
                this.builder = new ConfigMapNameReferenceBuilder(this, item);
                        
            }

            PolicyNestedImpl() {
                this.builder = new ConfigMapNameReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) SchedulerSpecFluentImpl.this.withPolicy(builder.build());
            }

            public N endPolicy() {
                return and();
            }
    }


}
