package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class APIServerSpecBuilder extends APIServerSpecFluentImpl<APIServerSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<APIServerSpec,APIServerSpecBuilder> {

    APIServerSpecFluent<?> fluent;
    Boolean validationEnabled;

    public APIServerSpecBuilder() {
        this(true);
    }

    public APIServerSpecBuilder(Boolean validationEnabled) {
        this(new APIServerSpec(), validationEnabled);
    }

    public APIServerSpecBuilder(APIServerSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public APIServerSpecBuilder(APIServerSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new APIServerSpec(), validationEnabled);
    }

    public APIServerSpecBuilder(APIServerSpecFluent<?> fluent,APIServerSpec instance) {
        this(fluent, instance, true);
    }

    public APIServerSpecBuilder(APIServerSpecFluent<?> fluent,APIServerSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAdditionalCORSAllowedOrigins(instance.getAdditionalCORSAllowedOrigins()); 
        fluent.withAudit(instance.getAudit()); 
        fluent.withClientCA(instance.getClientCA()); 
        fluent.withEncryption(instance.getEncryption()); 
        fluent.withServingCerts(instance.getServingCerts()); 
        fluent.withTlsSecurityProfile(instance.getTlsSecurityProfile()); 
        this.validationEnabled = validationEnabled; 
    }

    public APIServerSpecBuilder(APIServerSpec instance) {
        this(instance,true);
    }

    public APIServerSpecBuilder(APIServerSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAdditionalCORSAllowedOrigins(instance.getAdditionalCORSAllowedOrigins()); 
        this.withAudit(instance.getAudit()); 
        this.withClientCA(instance.getClientCA()); 
        this.withEncryption(instance.getEncryption()); 
        this.withServingCerts(instance.getServingCerts()); 
        this.withTlsSecurityProfile(instance.getTlsSecurityProfile()); 
        this.validationEnabled = validationEnabled; 
    }

    public APIServerSpec build() {
        APIServerSpec buildable = new APIServerSpec(fluent.getAdditionalCORSAllowedOrigins(),fluent.getAudit(),fluent.getClientCA(),fluent.getEncryption(),fluent.getServingCerts(),fluent.getTlsSecurityProfile());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        APIServerSpecBuilder that = (APIServerSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
