package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface APIServerSpecFluent<A extends APIServerSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public A addToAdditionalCORSAllowedOrigins(int index,String item);
    public A setToAdditionalCORSAllowedOrigins(int index,String item);
    public A addToAdditionalCORSAllowedOrigins(String... items);
    public A addAllToAdditionalCORSAllowedOrigins(Collection<String> items);
    public A removeFromAdditionalCORSAllowedOrigins(String... items);
    public A removeAllFromAdditionalCORSAllowedOrigins(Collection<String> items);
    public List<String> getAdditionalCORSAllowedOrigins();
    public String getAdditionalCORSAllowedOrigin(int index);
    public String getFirstAdditionalCORSAllowedOrigin();
    public String getLastAdditionalCORSAllowedOrigin();
    public String getMatchingAdditionalCORSAllowedOrigin(Predicate<String> predicate);
    public Boolean hasMatchingAdditionalCORSAllowedOrigin(Predicate<String> predicate);
    public A withAdditionalCORSAllowedOrigins(List<String> additionalCORSAllowedOrigins);
    public A withAdditionalCORSAllowedOrigins(String... additionalCORSAllowedOrigins);
    public Boolean hasAdditionalCORSAllowedOrigins();
    public A addNewAdditionalCORSAllowedOrigin(StringBuilder arg1);
    public A addNewAdditionalCORSAllowedOrigin(int[] arg1,int arg2,int arg3);
    public A addNewAdditionalCORSAllowedOrigin(char[] arg1);
    public A addNewAdditionalCORSAllowedOrigin(StringBuffer arg1);
    public A addNewAdditionalCORSAllowedOrigin(byte[] arg1,int arg2);
    public A addNewAdditionalCORSAllowedOrigin(byte[] arg1);
    public A addNewAdditionalCORSAllowedOrigin(char[] arg1,int arg2,int arg3);
    public A addNewAdditionalCORSAllowedOrigin(byte[] arg1,int arg2,int arg3);
    public A addNewAdditionalCORSAllowedOrigin(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewAdditionalCORSAllowedOrigin(String arg1);
    
/**
 * This method has been deprecated, please use method buildAudit instead.
 * @return The buildable object.
 */
@Deprecated public Audit getAudit();
    public Audit buildAudit();
    public A withAudit(Audit audit);
    public Boolean hasAudit();
    public A withNewAudit(String profile);
    public io.fabric8.openshift.api.model.APIServerSpecFluent.AuditNested<A> withNewAudit();
    public io.fabric8.openshift.api.model.APIServerSpecFluent.AuditNested<A> withNewAuditLike(Audit item);
    public io.fabric8.openshift.api.model.APIServerSpecFluent.AuditNested<A> editAudit();
    public io.fabric8.openshift.api.model.APIServerSpecFluent.AuditNested<A> editOrNewAudit();
    public io.fabric8.openshift.api.model.APIServerSpecFluent.AuditNested<A> editOrNewAuditLike(Audit item);
    
/**
 * This method has been deprecated, please use method buildClientCA instead.
 * @return The buildable object.
 */
@Deprecated public ConfigMapNameReference getClientCA();
    public ConfigMapNameReference buildClientCA();
    public A withClientCA(ConfigMapNameReference clientCA);
    public Boolean hasClientCA();
    public A withNewClientCA(String name);
    public io.fabric8.openshift.api.model.APIServerSpecFluent.ClientCANested<A> withNewClientCA();
    public io.fabric8.openshift.api.model.APIServerSpecFluent.ClientCANested<A> withNewClientCALike(ConfigMapNameReference item);
    public io.fabric8.openshift.api.model.APIServerSpecFluent.ClientCANested<A> editClientCA();
    public io.fabric8.openshift.api.model.APIServerSpecFluent.ClientCANested<A> editOrNewClientCA();
    public io.fabric8.openshift.api.model.APIServerSpecFluent.ClientCANested<A> editOrNewClientCALike(ConfigMapNameReference item);
    
/**
 * This method has been deprecated, please use method buildEncryption instead.
 * @return The buildable object.
 */
@Deprecated public APIServerEncryption getEncryption();
    public APIServerEncryption buildEncryption();
    public A withEncryption(APIServerEncryption encryption);
    public Boolean hasEncryption();
    public A withNewEncryption(String type);
    public io.fabric8.openshift.api.model.APIServerSpecFluent.EncryptionNested<A> withNewEncryption();
    public io.fabric8.openshift.api.model.APIServerSpecFluent.EncryptionNested<A> withNewEncryptionLike(APIServerEncryption item);
    public io.fabric8.openshift.api.model.APIServerSpecFluent.EncryptionNested<A> editEncryption();
    public io.fabric8.openshift.api.model.APIServerSpecFluent.EncryptionNested<A> editOrNewEncryption();
    public io.fabric8.openshift.api.model.APIServerSpecFluent.EncryptionNested<A> editOrNewEncryptionLike(APIServerEncryption item);
    
/**
 * This method has been deprecated, please use method buildServingCerts instead.
 * @return The buildable object.
 */
@Deprecated public APIServerServingCerts getServingCerts();
    public APIServerServingCerts buildServingCerts();
    public A withServingCerts(APIServerServingCerts servingCerts);
    public Boolean hasServingCerts();
    public io.fabric8.openshift.api.model.APIServerSpecFluent.ServingCertsNested<A> withNewServingCerts();
    public io.fabric8.openshift.api.model.APIServerSpecFluent.ServingCertsNested<A> withNewServingCertsLike(APIServerServingCerts item);
    public io.fabric8.openshift.api.model.APIServerSpecFluent.ServingCertsNested<A> editServingCerts();
    public io.fabric8.openshift.api.model.APIServerSpecFluent.ServingCertsNested<A> editOrNewServingCerts();
    public io.fabric8.openshift.api.model.APIServerSpecFluent.ServingCertsNested<A> editOrNewServingCertsLike(APIServerServingCerts item);
    
/**
 * This method has been deprecated, please use method buildTlsSecurityProfile instead.
 * @return The buildable object.
 */
@Deprecated public TLSSecurityProfile getTlsSecurityProfile();
    public TLSSecurityProfile buildTlsSecurityProfile();
    public A withTlsSecurityProfile(TLSSecurityProfile tlsSecurityProfile);
    public Boolean hasTlsSecurityProfile();
    public io.fabric8.openshift.api.model.APIServerSpecFluent.TlsSecurityProfileNested<A> withNewTlsSecurityProfile();
    public io.fabric8.openshift.api.model.APIServerSpecFluent.TlsSecurityProfileNested<A> withNewTlsSecurityProfileLike(TLSSecurityProfile item);
    public io.fabric8.openshift.api.model.APIServerSpecFluent.TlsSecurityProfileNested<A> editTlsSecurityProfile();
    public io.fabric8.openshift.api.model.APIServerSpecFluent.TlsSecurityProfileNested<A> editOrNewTlsSecurityProfile();
    public io.fabric8.openshift.api.model.APIServerSpecFluent.TlsSecurityProfileNested<A> editOrNewTlsSecurityProfileLike(TLSSecurityProfile item);
    public interface AuditNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AuditFluent<io.fabric8.openshift.api.model.APIServerSpecFluent.AuditNested<N>> {

            public N and();
            public N endAudit();    }


    public interface ClientCANested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ConfigMapNameReferenceFluent<io.fabric8.openshift.api.model.APIServerSpecFluent.ClientCANested<N>> {

            public N and();
            public N endClientCA();    }


    public interface EncryptionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,APIServerEncryptionFluent<io.fabric8.openshift.api.model.APIServerSpecFluent.EncryptionNested<N>> {

            public N and();
            public N endEncryption();    }


    public interface ServingCertsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,APIServerServingCertsFluent<io.fabric8.openshift.api.model.APIServerSpecFluent.ServingCertsNested<N>> {

            public N and();
            public N endServingCerts();    }


    public interface TlsSecurityProfileNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TLSSecurityProfileFluent<io.fabric8.openshift.api.model.APIServerSpecFluent.TlsSecurityProfileNested<N>> {

            public N and();
            public N endTlsSecurityProfile();    }


}
