package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AWSPlatformSpecBuilder extends AWSPlatformSpecFluentImpl<AWSPlatformSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<AWSPlatformSpec,AWSPlatformSpecBuilder> {

    AWSPlatformSpecFluent<?> fluent;
    Boolean validationEnabled;

    public AWSPlatformSpecBuilder() {
        this(true);
    }

    public AWSPlatformSpecBuilder(Boolean validationEnabled) {
        this(new AWSPlatformSpec(), validationEnabled);
    }

    public AWSPlatformSpecBuilder(AWSPlatformSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public AWSPlatformSpecBuilder(AWSPlatformSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new AWSPlatformSpec(), validationEnabled);
    }

    public AWSPlatformSpecBuilder(AWSPlatformSpecFluent<?> fluent,AWSPlatformSpec instance) {
        this(fluent, instance, true);
    }

    public AWSPlatformSpecBuilder(AWSPlatformSpecFluent<?> fluent,AWSPlatformSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withServiceEndpoints(instance.getServiceEndpoints()); 
        this.validationEnabled = validationEnabled; 
    }

    public AWSPlatformSpecBuilder(AWSPlatformSpec instance) {
        this(instance,true);
    }

    public AWSPlatformSpecBuilder(AWSPlatformSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withServiceEndpoints(instance.getServiceEndpoints()); 
        this.validationEnabled = validationEnabled; 
    }

    public AWSPlatformSpec build() {
        AWSPlatformSpec buildable = new AWSPlatformSpec(fluent.getServiceEndpoints());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        AWSPlatformSpecBuilder that = (AWSPlatformSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
