package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;
import java.lang.StringBuffer;

public interface BuildSpecFluent<A extends BuildSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public Long getCompletionDeadlineSeconds();
    public A withCompletionDeadlineSeconds(Long completionDeadlineSeconds);
    public Boolean hasCompletionDeadlineSeconds();
    public A withNewCompletionDeadlineSeconds(long arg1);
    public A addToNodeSelector(String key,String value);
    public A addToNodeSelector(java.util.Map<String,String> map);
    public A removeFromNodeSelector(String key);
    public A removeFromNodeSelector(java.util.Map<String,String> map);
    public java.util.Map<String,String> getNodeSelector();
    public <K extends Object,V extends Object>A withNodeSelector(java.util.Map<String,String> nodeSelector);
    public Boolean hasNodeSelector();
    
/**
 * This method has been deprecated, please use method buildOutput instead.
 * @return The buildable object.
 */
@Deprecated public BuildOutput getOutput();
    public BuildOutput buildOutput();
    public A withOutput(BuildOutput output);
    public Boolean hasOutput();
    public io.fabric8.openshift.api.model.BuildSpecFluent.OutputNested<A> withNewOutput();
    public io.fabric8.openshift.api.model.BuildSpecFluent.OutputNested<A> withNewOutputLike(BuildOutput item);
    public io.fabric8.openshift.api.model.BuildSpecFluent.OutputNested<A> editOutput();
    public io.fabric8.openshift.api.model.BuildSpecFluent.OutputNested<A> editOrNewOutput();
    public io.fabric8.openshift.api.model.BuildSpecFluent.OutputNested<A> editOrNewOutputLike(BuildOutput item);
    
/**
 * This method has been deprecated, please use method buildPostCommit instead.
 * @return The buildable object.
 */
@Deprecated public BuildPostCommitSpec getPostCommit();
    public BuildPostCommitSpec buildPostCommit();
    public A withPostCommit(BuildPostCommitSpec postCommit);
    public Boolean hasPostCommit();
    public io.fabric8.openshift.api.model.BuildSpecFluent.PostCommitNested<A> withNewPostCommit();
    public io.fabric8.openshift.api.model.BuildSpecFluent.PostCommitNested<A> withNewPostCommitLike(BuildPostCommitSpec item);
    public io.fabric8.openshift.api.model.BuildSpecFluent.PostCommitNested<A> editPostCommit();
    public io.fabric8.openshift.api.model.BuildSpecFluent.PostCommitNested<A> editOrNewPostCommit();
    public io.fabric8.openshift.api.model.BuildSpecFluent.PostCommitNested<A> editOrNewPostCommitLike(BuildPostCommitSpec item);
    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@Deprecated public ResourceRequirements getResources();
    public ResourceRequirements buildResources();
    public A withResources(ResourceRequirements resources);
    public Boolean hasResources();
    public io.fabric8.openshift.api.model.BuildSpecFluent.ResourcesNested<A> withNewResources();
    public io.fabric8.openshift.api.model.BuildSpecFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item);
    public io.fabric8.openshift.api.model.BuildSpecFluent.ResourcesNested<A> editResources();
    public io.fabric8.openshift.api.model.BuildSpecFluent.ResourcesNested<A> editOrNewResources();
    public io.fabric8.openshift.api.model.BuildSpecFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item);
    
/**
 * This method has been deprecated, please use method buildRevision instead.
 * @return The buildable object.
 */
@Deprecated public SourceRevision getRevision();
    public SourceRevision buildRevision();
    public A withRevision(SourceRevision revision);
    public Boolean hasRevision();
    public io.fabric8.openshift.api.model.BuildSpecFluent.RevisionNested<A> withNewRevision();
    public io.fabric8.openshift.api.model.BuildSpecFluent.RevisionNested<A> withNewRevisionLike(SourceRevision item);
    public io.fabric8.openshift.api.model.BuildSpecFluent.RevisionNested<A> editRevision();
    public io.fabric8.openshift.api.model.BuildSpecFluent.RevisionNested<A> editOrNewRevision();
    public io.fabric8.openshift.api.model.BuildSpecFluent.RevisionNested<A> editOrNewRevisionLike(SourceRevision item);
    public String getServiceAccount();
    public A withServiceAccount(String serviceAccount);
    public Boolean hasServiceAccount();
    public A withNewServiceAccount(StringBuilder arg1);
    public A withNewServiceAccount(int[] arg1,int arg2,int arg3);
    public A withNewServiceAccount(char[] arg1);
    public A withNewServiceAccount(StringBuffer arg1);
    public A withNewServiceAccount(byte[] arg1,int arg2);
    public A withNewServiceAccount(byte[] arg1);
    public A withNewServiceAccount(char[] arg1,int arg2,int arg3);
    public A withNewServiceAccount(byte[] arg1,int arg2,int arg3);
    public A withNewServiceAccount(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewServiceAccount(String arg1);
    
/**
 * This method has been deprecated, please use method buildSource instead.
 * @return The buildable object.
 */
@Deprecated public BuildSource getSource();
    public BuildSource buildSource();
    public A withSource(BuildSource source);
    public Boolean hasSource();
    public io.fabric8.openshift.api.model.BuildSpecFluent.SourceNested<A> withNewSource();
    public io.fabric8.openshift.api.model.BuildSpecFluent.SourceNested<A> withNewSourceLike(BuildSource item);
    public io.fabric8.openshift.api.model.BuildSpecFluent.SourceNested<A> editSource();
    public io.fabric8.openshift.api.model.BuildSpecFluent.SourceNested<A> editOrNewSource();
    public io.fabric8.openshift.api.model.BuildSpecFluent.SourceNested<A> editOrNewSourceLike(BuildSource item);
    
/**
 * This method has been deprecated, please use method buildStrategy instead.
 * @return The buildable object.
 */
@Deprecated public BuildStrategy getStrategy();
    public BuildStrategy buildStrategy();
    public A withStrategy(BuildStrategy strategy);
    public Boolean hasStrategy();
    public io.fabric8.openshift.api.model.BuildSpecFluent.StrategyNested<A> withNewStrategy();
    public io.fabric8.openshift.api.model.BuildSpecFluent.StrategyNested<A> withNewStrategyLike(BuildStrategy item);
    public io.fabric8.openshift.api.model.BuildSpecFluent.StrategyNested<A> editStrategy();
    public io.fabric8.openshift.api.model.BuildSpecFluent.StrategyNested<A> editOrNewStrategy();
    public io.fabric8.openshift.api.model.BuildSpecFluent.StrategyNested<A> editOrNewStrategyLike(BuildStrategy item);
    public A addToTriggeredBy(int index,BuildTriggerCause item);
    public A setToTriggeredBy(int index,BuildTriggerCause item);
    public A addToTriggeredBy(BuildTriggerCause... items);
    public A addAllToTriggeredBy(Collection<BuildTriggerCause> items);
    public A removeFromTriggeredBy(BuildTriggerCause... items);
    public A removeAllFromTriggeredBy(Collection<BuildTriggerCause> items);
    public A removeMatchingFromTriggeredBy(Predicate<BuildTriggerCauseBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildTriggeredBy instead.
 * @return The buildable object.
 */
@Deprecated public List<BuildTriggerCause> getTriggeredBy();
    public List<BuildTriggerCause> buildTriggeredBy();
    public BuildTriggerCause buildTriggeredBy(int index);
    public BuildTriggerCause buildFirstTriggeredBy();
    public BuildTriggerCause buildLastTriggeredBy();
    public BuildTriggerCause buildMatchingTriggeredBy(Predicate<BuildTriggerCauseBuilder> predicate);
    public Boolean hasMatchingTriggeredBy(Predicate<BuildTriggerCauseBuilder> predicate);
    public A withTriggeredBy(List<BuildTriggerCause> triggeredBy);
    public A withTriggeredBy(BuildTriggerCause... triggeredBy);
    public Boolean hasTriggeredBy();
    public io.fabric8.openshift.api.model.BuildSpecFluent.TriggeredByNested<A> addNewTriggeredBy();
    public io.fabric8.openshift.api.model.BuildSpecFluent.TriggeredByNested<A> addNewTriggeredByLike(BuildTriggerCause item);
    public io.fabric8.openshift.api.model.BuildSpecFluent.TriggeredByNested<A> setNewTriggeredByLike(int index,BuildTriggerCause item);
    public io.fabric8.openshift.api.model.BuildSpecFluent.TriggeredByNested<A> editTriggeredBy(int index);
    public io.fabric8.openshift.api.model.BuildSpecFluent.TriggeredByNested<A> editFirstTriggeredBy();
    public io.fabric8.openshift.api.model.BuildSpecFluent.TriggeredByNested<A> editLastTriggeredBy();
    public io.fabric8.openshift.api.model.BuildSpecFluent.TriggeredByNested<A> editMatchingTriggeredBy(Predicate<BuildTriggerCauseBuilder> predicate);
    public interface OutputNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildOutputFluent<io.fabric8.openshift.api.model.BuildSpecFluent.OutputNested<N>> {

            public N and();
            public N endOutput();    }


    public interface PostCommitNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildPostCommitSpecFluent<io.fabric8.openshift.api.model.BuildSpecFluent.PostCommitNested<N>> {

            public N and();
            public N endPostCommit();    }


    public interface ResourcesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ResourceRequirementsFluent<io.fabric8.openshift.api.model.BuildSpecFluent.ResourcesNested<N>> {

            public N and();
            public N endResources();    }


    public interface RevisionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SourceRevisionFluent<io.fabric8.openshift.api.model.BuildSpecFluent.RevisionNested<N>> {

            public N and();
            public N endRevision();    }


    public interface SourceNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildSourceFluent<io.fabric8.openshift.api.model.BuildSpecFluent.SourceNested<N>> {

            public N and();
            public N endSource();    }


    public interface StrategyNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildStrategyFluent<io.fabric8.openshift.api.model.BuildSpecFluent.StrategyNested<N>> {

            public N and();
            public N endStrategy();    }


    public interface TriggeredByNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildTriggerCauseFluent<io.fabric8.openshift.api.model.BuildSpecFluent.TriggeredByNested<N>> {

            public N and();
            public N endTriggeredBy();    }


}
