package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ClusterNetworkListBuilder extends ClusterNetworkListFluentImpl<ClusterNetworkListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<ClusterNetworkList,ClusterNetworkListBuilder> {

    ClusterNetworkListFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterNetworkListBuilder() {
        this(true);
    }

    public ClusterNetworkListBuilder(Boolean validationEnabled) {
        this(new ClusterNetworkList(), validationEnabled);
    }

    public ClusterNetworkListBuilder(ClusterNetworkListFluent<?> fluent) {
        this(fluent, true);
    }

    public ClusterNetworkListBuilder(ClusterNetworkListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ClusterNetworkList(), validationEnabled);
    }

    public ClusterNetworkListBuilder(ClusterNetworkListFluent<?> fluent,ClusterNetworkList instance) {
        this(fluent, instance, true);
    }

    public ClusterNetworkListBuilder(ClusterNetworkListFluent<?> fluent,ClusterNetworkList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public ClusterNetworkListBuilder(ClusterNetworkList instance) {
        this(instance,true);
    }

    public ClusterNetworkListBuilder(ClusterNetworkList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public ClusterNetworkList build() {
        ClusterNetworkList buildable = new ClusterNetworkList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ClusterNetworkListBuilder that = (ClusterNetworkListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
