package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ClusterRoleScopeRestrictionBuilder extends ClusterRoleScopeRestrictionFluentImpl<ClusterRoleScopeRestrictionBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<ClusterRoleScopeRestriction,ClusterRoleScopeRestrictionBuilder> {

    ClusterRoleScopeRestrictionFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterRoleScopeRestrictionBuilder() {
        this(true);
    }

    public ClusterRoleScopeRestrictionBuilder(Boolean validationEnabled) {
        this(new ClusterRoleScopeRestriction(), validationEnabled);
    }

    public ClusterRoleScopeRestrictionBuilder(ClusterRoleScopeRestrictionFluent<?> fluent) {
        this(fluent, true);
    }

    public ClusterRoleScopeRestrictionBuilder(ClusterRoleScopeRestrictionFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ClusterRoleScopeRestriction(), validationEnabled);
    }

    public ClusterRoleScopeRestrictionBuilder(ClusterRoleScopeRestrictionFluent<?> fluent,ClusterRoleScopeRestriction instance) {
        this(fluent, instance, true);
    }

    public ClusterRoleScopeRestrictionBuilder(ClusterRoleScopeRestrictionFluent<?> fluent,ClusterRoleScopeRestriction instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAllowEscalation(instance.getAllowEscalation()); 
        fluent.withNamespaces(instance.getNamespaces()); 
        fluent.withRoleNames(instance.getRoleNames()); 
        this.validationEnabled = validationEnabled; 
    }

    public ClusterRoleScopeRestrictionBuilder(ClusterRoleScopeRestriction instance) {
        this(instance,true);
    }

    public ClusterRoleScopeRestrictionBuilder(ClusterRoleScopeRestriction instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAllowEscalation(instance.getAllowEscalation()); 
        this.withNamespaces(instance.getNamespaces()); 
        this.withRoleNames(instance.getRoleNames()); 
        this.validationEnabled = validationEnabled; 
    }

    public ClusterRoleScopeRestriction build() {
        ClusterRoleScopeRestriction buildable = new ClusterRoleScopeRestriction(fluent.getAllowEscalation(),fluent.getNamespaces(),fluent.getRoleNames());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ClusterRoleScopeRestrictionBuilder that = (ClusterRoleScopeRestrictionBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
