package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ClusterVersionSpecBuilder extends ClusterVersionSpecFluentImpl<ClusterVersionSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<ClusterVersionSpec,ClusterVersionSpecBuilder> {

    ClusterVersionSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterVersionSpecBuilder() {
        this(true);
    }

    public ClusterVersionSpecBuilder(Boolean validationEnabled) {
        this(new ClusterVersionSpec(), validationEnabled);
    }

    public ClusterVersionSpecBuilder(ClusterVersionSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public ClusterVersionSpecBuilder(ClusterVersionSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ClusterVersionSpec(), validationEnabled);
    }

    public ClusterVersionSpecBuilder(ClusterVersionSpecFluent<?> fluent,ClusterVersionSpec instance) {
        this(fluent, instance, true);
    }

    public ClusterVersionSpecBuilder(ClusterVersionSpecFluent<?> fluent,ClusterVersionSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withChannel(instance.getChannel()); 
        fluent.withClusterID(instance.getClusterID()); 
        fluent.withDesiredUpdate(instance.getDesiredUpdate()); 
        fluent.withOverrides(instance.getOverrides()); 
        fluent.withUpstream(instance.getUpstream()); 
        this.validationEnabled = validationEnabled; 
    }

    public ClusterVersionSpecBuilder(ClusterVersionSpec instance) {
        this(instance,true);
    }

    public ClusterVersionSpecBuilder(ClusterVersionSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withChannel(instance.getChannel()); 
        this.withClusterID(instance.getClusterID()); 
        this.withDesiredUpdate(instance.getDesiredUpdate()); 
        this.withOverrides(instance.getOverrides()); 
        this.withUpstream(instance.getUpstream()); 
        this.validationEnabled = validationEnabled; 
    }

    public ClusterVersionSpec build() {
        ClusterVersionSpec buildable = new ClusterVersionSpec(fluent.getChannel(),fluent.getClusterID(),fluent.getDesiredUpdate(),fluent.getOverrides(),fluent.getUpstream());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ClusterVersionSpecBuilder that = (ClusterVersionSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
