package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface ClusterVersionStatusFluent<A extends ClusterVersionStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public A addToAvailableUpdates(int index,Release item);
    public A setToAvailableUpdates(int index,Release item);
    public A addToAvailableUpdates(Release... items);
    public A addAllToAvailableUpdates(Collection<Release> items);
    public A removeFromAvailableUpdates(Release... items);
    public A removeAllFromAvailableUpdates(Collection<Release> items);
    public A removeMatchingFromAvailableUpdates(Predicate<ReleaseBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildAvailableUpdates instead.
 * @return The buildable object.
 */
@Deprecated public List<Release> getAvailableUpdates();
    public List<Release> buildAvailableUpdates();
    public Release buildAvailableUpdate(int index);
    public Release buildFirstAvailableUpdate();
    public Release buildLastAvailableUpdate();
    public Release buildMatchingAvailableUpdate(Predicate<ReleaseBuilder> predicate);
    public Boolean hasMatchingAvailableUpdate(Predicate<ReleaseBuilder> predicate);
    public A withAvailableUpdates(List<Release> availableUpdates);
    public A withAvailableUpdates(Release... availableUpdates);
    public Boolean hasAvailableUpdates();
    public io.fabric8.openshift.api.model.ClusterVersionStatusFluent.AvailableUpdatesNested<A> addNewAvailableUpdate();
    public io.fabric8.openshift.api.model.ClusterVersionStatusFluent.AvailableUpdatesNested<A> addNewAvailableUpdateLike(Release item);
    public io.fabric8.openshift.api.model.ClusterVersionStatusFluent.AvailableUpdatesNested<A> setNewAvailableUpdateLike(int index,Release item);
    public io.fabric8.openshift.api.model.ClusterVersionStatusFluent.AvailableUpdatesNested<A> editAvailableUpdate(int index);
    public io.fabric8.openshift.api.model.ClusterVersionStatusFluent.AvailableUpdatesNested<A> editFirstAvailableUpdate();
    public io.fabric8.openshift.api.model.ClusterVersionStatusFluent.AvailableUpdatesNested<A> editLastAvailableUpdate();
    public io.fabric8.openshift.api.model.ClusterVersionStatusFluent.AvailableUpdatesNested<A> editMatchingAvailableUpdate(Predicate<ReleaseBuilder> predicate);
    public A addToConditions(int index,ClusterOperatorStatusCondition item);
    public A setToConditions(int index,ClusterOperatorStatusCondition item);
    public A addToConditions(ClusterOperatorStatusCondition... items);
    public A addAllToConditions(Collection<ClusterOperatorStatusCondition> items);
    public A removeFromConditions(ClusterOperatorStatusCondition... items);
    public A removeAllFromConditions(Collection<ClusterOperatorStatusCondition> items);
    public A removeMatchingFromConditions(Predicate<ClusterOperatorStatusConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<ClusterOperatorStatusCondition> getConditions();
    public List<ClusterOperatorStatusCondition> buildConditions();
    public ClusterOperatorStatusCondition buildCondition(int index);
    public ClusterOperatorStatusCondition buildFirstCondition();
    public ClusterOperatorStatusCondition buildLastCondition();
    public ClusterOperatorStatusCondition buildMatchingCondition(Predicate<ClusterOperatorStatusConditionBuilder> predicate);
    public Boolean hasMatchingCondition(Predicate<ClusterOperatorStatusConditionBuilder> predicate);
    public A withConditions(List<ClusterOperatorStatusCondition> conditions);
    public A withConditions(ClusterOperatorStatusCondition... conditions);
    public Boolean hasConditions();
    public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type);
    public io.fabric8.openshift.api.model.ClusterVersionStatusFluent.ConditionsNested<A> addNewCondition();
    public io.fabric8.openshift.api.model.ClusterVersionStatusFluent.ConditionsNested<A> addNewConditionLike(ClusterOperatorStatusCondition item);
    public io.fabric8.openshift.api.model.ClusterVersionStatusFluent.ConditionsNested<A> setNewConditionLike(int index,ClusterOperatorStatusCondition item);
    public io.fabric8.openshift.api.model.ClusterVersionStatusFluent.ConditionsNested<A> editCondition(int index);
    public io.fabric8.openshift.api.model.ClusterVersionStatusFluent.ConditionsNested<A> editFirstCondition();
    public io.fabric8.openshift.api.model.ClusterVersionStatusFluent.ConditionsNested<A> editLastCondition();
    public io.fabric8.openshift.api.model.ClusterVersionStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ClusterOperatorStatusConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildDesired instead.
 * @return The buildable object.
 */
@Deprecated public Release getDesired();
    public Release buildDesired();
    public A withDesired(Release desired);
    public Boolean hasDesired();
    public io.fabric8.openshift.api.model.ClusterVersionStatusFluent.DesiredNested<A> withNewDesired();
    public io.fabric8.openshift.api.model.ClusterVersionStatusFluent.DesiredNested<A> withNewDesiredLike(Release item);
    public io.fabric8.openshift.api.model.ClusterVersionStatusFluent.DesiredNested<A> editDesired();
    public io.fabric8.openshift.api.model.ClusterVersionStatusFluent.DesiredNested<A> editOrNewDesired();
    public io.fabric8.openshift.api.model.ClusterVersionStatusFluent.DesiredNested<A> editOrNewDesiredLike(Release item);
    public A addToHistory(int index,UpdateHistory item);
    public A setToHistory(int index,UpdateHistory item);
    public A addToHistory(UpdateHistory... items);
    public A addAllToHistory(Collection<UpdateHistory> items);
    public A removeFromHistory(UpdateHistory... items);
    public A removeAllFromHistory(Collection<UpdateHistory> items);
    public A removeMatchingFromHistory(Predicate<UpdateHistoryBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildHistory instead.
 * @return The buildable object.
 */
@Deprecated public List<UpdateHistory> getHistory();
    public List<UpdateHistory> buildHistory();
    public UpdateHistory buildHistory(int index);
    public UpdateHistory buildFirstHistory();
    public UpdateHistory buildLastHistory();
    public UpdateHistory buildMatchingHistory(Predicate<UpdateHistoryBuilder> predicate);
    public Boolean hasMatchingHistory(Predicate<UpdateHistoryBuilder> predicate);
    public A withHistory(List<UpdateHistory> history);
    public A withHistory(UpdateHistory... history);
    public Boolean hasHistory();
    public io.fabric8.openshift.api.model.ClusterVersionStatusFluent.HistoryNested<A> addNewHistory();
    public io.fabric8.openshift.api.model.ClusterVersionStatusFluent.HistoryNested<A> addNewHistoryLike(UpdateHistory item);
    public io.fabric8.openshift.api.model.ClusterVersionStatusFluent.HistoryNested<A> setNewHistoryLike(int index,UpdateHistory item);
    public io.fabric8.openshift.api.model.ClusterVersionStatusFluent.HistoryNested<A> editHistory(int index);
    public io.fabric8.openshift.api.model.ClusterVersionStatusFluent.HistoryNested<A> editFirstHistory();
    public io.fabric8.openshift.api.model.ClusterVersionStatusFluent.HistoryNested<A> editLastHistory();
    public io.fabric8.openshift.api.model.ClusterVersionStatusFluent.HistoryNested<A> editMatchingHistory(Predicate<UpdateHistoryBuilder> predicate);
    public Long getObservedGeneration();
    public A withObservedGeneration(Long observedGeneration);
    public Boolean hasObservedGeneration();
    public A withNewObservedGeneration(long arg1);
    public String getVersionHash();
    public A withVersionHash(String versionHash);
    public Boolean hasVersionHash();
    public A withNewVersionHash(StringBuilder arg1);
    public A withNewVersionHash(int[] arg1,int arg2,int arg3);
    public A withNewVersionHash(char[] arg1);
    public A withNewVersionHash(StringBuffer arg1);
    public A withNewVersionHash(byte[] arg1,int arg2);
    public A withNewVersionHash(byte[] arg1);
    public A withNewVersionHash(char[] arg1,int arg2,int arg3);
    public A withNewVersionHash(byte[] arg1,int arg2,int arg3);
    public A withNewVersionHash(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewVersionHash(String arg1);
    public interface AvailableUpdatesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ReleaseFluent<io.fabric8.openshift.api.model.ClusterVersionStatusFluent.AvailableUpdatesNested<N>> {

            public N and();
            public N endAvailableUpdate();    }


    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterOperatorStatusConditionFluent<io.fabric8.openshift.api.model.ClusterVersionStatusFluent.ConditionsNested<N>> {

            public N and();
            public N endCondition();    }


    public interface DesiredNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ReleaseFluent<io.fabric8.openshift.api.model.ClusterVersionStatusFluent.DesiredNested<N>> {

            public N and();
            public N endDesired();    }


    public interface HistoryNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,UpdateHistoryFluent<io.fabric8.openshift.api.model.ClusterVersionStatusFluent.HistoryNested<N>> {

            public N and();
            public N endHistory();    }


}
