package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.lang.StringBuffer;

public class IdentityProviderFluentImpl<A extends IdentityProviderFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements IdentityProviderFluent<A> {

    private BasicAuthIdentityProviderBuilder basicAuth;
    private GitHubIdentityProviderBuilder github;
    private GitLabIdentityProviderBuilder gitlab;
    private GoogleIdentityProviderBuilder google;
    private HTPasswdIdentityProviderBuilder htpasswd;
    private KeystoneIdentityProviderBuilder keystone;
    private LDAPIdentityProviderBuilder ldap;
    private String mappingMethod;
    private String name;
    private OpenIDIdentityProviderBuilder openID;
    private RequestHeaderIdentityProviderBuilder requestHeader;
    private String type;

    public IdentityProviderFluentImpl() {
    }

    public IdentityProviderFluentImpl(IdentityProvider instance) {
        this.withBasicAuth(instance.getBasicAuth()); 
        this.withGithub(instance.getGithub()); 
        this.withGitlab(instance.getGitlab()); 
        this.withGoogle(instance.getGoogle()); 
        this.withHtpasswd(instance.getHtpasswd()); 
        this.withKeystone(instance.getKeystone()); 
        this.withLdap(instance.getLdap()); 
        this.withMappingMethod(instance.getMappingMethod()); 
        this.withName(instance.getName()); 
        this.withOpenID(instance.getOpenID()); 
        this.withRequestHeader(instance.getRequestHeader()); 
        this.withType(instance.getType()); 
    }

    
/**
 * This method has been deprecated, please use method buildBasicAuth instead.
 * @return The buildable object.
 */
@Deprecated public BasicAuthIdentityProvider getBasicAuth() {
        return this.basicAuth!=null?this.basicAuth.build():null;
    }

    public BasicAuthIdentityProvider buildBasicAuth() {
        return this.basicAuth!=null?this.basicAuth.build():null;
    }

    public A withBasicAuth(BasicAuthIdentityProvider basicAuth) {
        _visitables.get("basicAuth").remove(this.basicAuth);
        if (basicAuth!=null){ this.basicAuth= new BasicAuthIdentityProviderBuilder(basicAuth); _visitables.get("basicAuth").add(this.basicAuth);} return (A) this;
    }

    public Boolean hasBasicAuth() {
        return this.basicAuth != null;
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.BasicAuthNested<A> withNewBasicAuth() {
        return new BasicAuthNestedImpl();
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.BasicAuthNested<A> withNewBasicAuthLike(BasicAuthIdentityProvider item) {
        return new BasicAuthNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.BasicAuthNested<A> editBasicAuth() {
        return withNewBasicAuthLike(getBasicAuth());
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.BasicAuthNested<A> editOrNewBasicAuth() {
        return withNewBasicAuthLike(getBasicAuth() != null ? getBasicAuth(): new BasicAuthIdentityProviderBuilder().build());
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.BasicAuthNested<A> editOrNewBasicAuthLike(BasicAuthIdentityProvider item) {
        return withNewBasicAuthLike(getBasicAuth() != null ? getBasicAuth(): item);
    }

    
/**
 * This method has been deprecated, please use method buildGithub instead.
 * @return The buildable object.
 */
@Deprecated public GitHubIdentityProvider getGithub() {
        return this.github!=null?this.github.build():null;
    }

    public GitHubIdentityProvider buildGithub() {
        return this.github!=null?this.github.build():null;
    }

    public A withGithub(GitHubIdentityProvider github) {
        _visitables.get("github").remove(this.github);
        if (github!=null){ this.github= new GitHubIdentityProviderBuilder(github); _visitables.get("github").add(this.github);} return (A) this;
    }

    public Boolean hasGithub() {
        return this.github != null;
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.GithubNested<A> withNewGithub() {
        return new GithubNestedImpl();
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.GithubNested<A> withNewGithubLike(GitHubIdentityProvider item) {
        return new GithubNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.GithubNested<A> editGithub() {
        return withNewGithubLike(getGithub());
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.GithubNested<A> editOrNewGithub() {
        return withNewGithubLike(getGithub() != null ? getGithub(): new GitHubIdentityProviderBuilder().build());
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.GithubNested<A> editOrNewGithubLike(GitHubIdentityProvider item) {
        return withNewGithubLike(getGithub() != null ? getGithub(): item);
    }

    
/**
 * This method has been deprecated, please use method buildGitlab instead.
 * @return The buildable object.
 */
@Deprecated public GitLabIdentityProvider getGitlab() {
        return this.gitlab!=null?this.gitlab.build():null;
    }

    public GitLabIdentityProvider buildGitlab() {
        return this.gitlab!=null?this.gitlab.build():null;
    }

    public A withGitlab(GitLabIdentityProvider gitlab) {
        _visitables.get("gitlab").remove(this.gitlab);
        if (gitlab!=null){ this.gitlab= new GitLabIdentityProviderBuilder(gitlab); _visitables.get("gitlab").add(this.gitlab);} return (A) this;
    }

    public Boolean hasGitlab() {
        return this.gitlab != null;
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.GitlabNested<A> withNewGitlab() {
        return new GitlabNestedImpl();
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.GitlabNested<A> withNewGitlabLike(GitLabIdentityProvider item) {
        return new GitlabNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.GitlabNested<A> editGitlab() {
        return withNewGitlabLike(getGitlab());
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.GitlabNested<A> editOrNewGitlab() {
        return withNewGitlabLike(getGitlab() != null ? getGitlab(): new GitLabIdentityProviderBuilder().build());
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.GitlabNested<A> editOrNewGitlabLike(GitLabIdentityProvider item) {
        return withNewGitlabLike(getGitlab() != null ? getGitlab(): item);
    }

    
/**
 * This method has been deprecated, please use method buildGoogle instead.
 * @return The buildable object.
 */
@Deprecated public GoogleIdentityProvider getGoogle() {
        return this.google!=null?this.google.build():null;
    }

    public GoogleIdentityProvider buildGoogle() {
        return this.google!=null?this.google.build():null;
    }

    public A withGoogle(GoogleIdentityProvider google) {
        _visitables.get("google").remove(this.google);
        if (google!=null){ this.google= new GoogleIdentityProviderBuilder(google); _visitables.get("google").add(this.google);} return (A) this;
    }

    public Boolean hasGoogle() {
        return this.google != null;
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.GoogleNested<A> withNewGoogle() {
        return new GoogleNestedImpl();
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.GoogleNested<A> withNewGoogleLike(GoogleIdentityProvider item) {
        return new GoogleNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.GoogleNested<A> editGoogle() {
        return withNewGoogleLike(getGoogle());
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.GoogleNested<A> editOrNewGoogle() {
        return withNewGoogleLike(getGoogle() != null ? getGoogle(): new GoogleIdentityProviderBuilder().build());
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.GoogleNested<A> editOrNewGoogleLike(GoogleIdentityProvider item) {
        return withNewGoogleLike(getGoogle() != null ? getGoogle(): item);
    }

    
/**
 * This method has been deprecated, please use method buildHtpasswd instead.
 * @return The buildable object.
 */
@Deprecated public HTPasswdIdentityProvider getHtpasswd() {
        return this.htpasswd!=null?this.htpasswd.build():null;
    }

    public HTPasswdIdentityProvider buildHtpasswd() {
        return this.htpasswd!=null?this.htpasswd.build():null;
    }

    public A withHtpasswd(HTPasswdIdentityProvider htpasswd) {
        _visitables.get("htpasswd").remove(this.htpasswd);
        if (htpasswd!=null){ this.htpasswd= new HTPasswdIdentityProviderBuilder(htpasswd); _visitables.get("htpasswd").add(this.htpasswd);} return (A) this;
    }

    public Boolean hasHtpasswd() {
        return this.htpasswd != null;
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.HtpasswdNested<A> withNewHtpasswd() {
        return new HtpasswdNestedImpl();
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.HtpasswdNested<A> withNewHtpasswdLike(HTPasswdIdentityProvider item) {
        return new HtpasswdNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.HtpasswdNested<A> editHtpasswd() {
        return withNewHtpasswdLike(getHtpasswd());
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.HtpasswdNested<A> editOrNewHtpasswd() {
        return withNewHtpasswdLike(getHtpasswd() != null ? getHtpasswd(): new HTPasswdIdentityProviderBuilder().build());
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.HtpasswdNested<A> editOrNewHtpasswdLike(HTPasswdIdentityProvider item) {
        return withNewHtpasswdLike(getHtpasswd() != null ? getHtpasswd(): item);
    }

    
/**
 * This method has been deprecated, please use method buildKeystone instead.
 * @return The buildable object.
 */
@Deprecated public KeystoneIdentityProvider getKeystone() {
        return this.keystone!=null?this.keystone.build():null;
    }

    public KeystoneIdentityProvider buildKeystone() {
        return this.keystone!=null?this.keystone.build():null;
    }

    public A withKeystone(KeystoneIdentityProvider keystone) {
        _visitables.get("keystone").remove(this.keystone);
        if (keystone!=null){ this.keystone= new KeystoneIdentityProviderBuilder(keystone); _visitables.get("keystone").add(this.keystone);} return (A) this;
    }

    public Boolean hasKeystone() {
        return this.keystone != null;
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.KeystoneNested<A> withNewKeystone() {
        return new KeystoneNestedImpl();
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.KeystoneNested<A> withNewKeystoneLike(KeystoneIdentityProvider item) {
        return new KeystoneNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.KeystoneNested<A> editKeystone() {
        return withNewKeystoneLike(getKeystone());
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.KeystoneNested<A> editOrNewKeystone() {
        return withNewKeystoneLike(getKeystone() != null ? getKeystone(): new KeystoneIdentityProviderBuilder().build());
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.KeystoneNested<A> editOrNewKeystoneLike(KeystoneIdentityProvider item) {
        return withNewKeystoneLike(getKeystone() != null ? getKeystone(): item);
    }

    
/**
 * This method has been deprecated, please use method buildLdap instead.
 * @return The buildable object.
 */
@Deprecated public LDAPIdentityProvider getLdap() {
        return this.ldap!=null?this.ldap.build():null;
    }

    public LDAPIdentityProvider buildLdap() {
        return this.ldap!=null?this.ldap.build():null;
    }

    public A withLdap(LDAPIdentityProvider ldap) {
        _visitables.get("ldap").remove(this.ldap);
        if (ldap!=null){ this.ldap= new LDAPIdentityProviderBuilder(ldap); _visitables.get("ldap").add(this.ldap);} return (A) this;
    }

    public Boolean hasLdap() {
        return this.ldap != null;
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.LdapNested<A> withNewLdap() {
        return new LdapNestedImpl();
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.LdapNested<A> withNewLdapLike(LDAPIdentityProvider item) {
        return new LdapNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.LdapNested<A> editLdap() {
        return withNewLdapLike(getLdap());
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.LdapNested<A> editOrNewLdap() {
        return withNewLdapLike(getLdap() != null ? getLdap(): new LDAPIdentityProviderBuilder().build());
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.LdapNested<A> editOrNewLdapLike(LDAPIdentityProvider item) {
        return withNewLdapLike(getLdap() != null ? getLdap(): item);
    }

    public String getMappingMethod() {
        return this.mappingMethod;
    }

    public A withMappingMethod(String mappingMethod) {
        this.mappingMethod=mappingMethod; return (A) this;
    }

    public Boolean hasMappingMethod() {
        return this.mappingMethod != null;
    }

    public A withNewMappingMethod(StringBuilder arg1) {
        return (A)withMappingMethod(new String(arg1));
    }

    public A withNewMappingMethod(int[] arg1,int arg2,int arg3) {
        return (A)withMappingMethod(new String(arg1, arg2, arg3));
    }

    public A withNewMappingMethod(char[] arg1) {
        return (A)withMappingMethod(new String(arg1));
    }

    public A withNewMappingMethod(StringBuffer arg1) {
        return (A)withMappingMethod(new String(arg1));
    }

    public A withNewMappingMethod(byte[] arg1,int arg2) {
        return (A)withMappingMethod(new String(arg1, arg2));
    }

    public A withNewMappingMethod(byte[] arg1) {
        return (A)withMappingMethod(new String(arg1));
    }

    public A withNewMappingMethod(char[] arg1,int arg2,int arg3) {
        return (A)withMappingMethod(new String(arg1, arg2, arg3));
    }

    public A withNewMappingMethod(byte[] arg1,int arg2,int arg3) {
        return (A)withMappingMethod(new String(arg1, arg2, arg3));
    }

    public A withNewMappingMethod(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withMappingMethod(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewMappingMethod(String arg1) {
        return (A)withMappingMethod(new String(arg1));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(int[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(char[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(byte[] arg1,int arg2) {
        return (A)withName(new String(arg1, arg2));
    }

    public A withNewName(byte[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(char[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildOpenID instead.
 * @return The buildable object.
 */
@Deprecated public OpenIDIdentityProvider getOpenID() {
        return this.openID!=null?this.openID.build():null;
    }

    public OpenIDIdentityProvider buildOpenID() {
        return this.openID!=null?this.openID.build():null;
    }

    public A withOpenID(OpenIDIdentityProvider openID) {
        _visitables.get("openID").remove(this.openID);
        if (openID!=null){ this.openID= new OpenIDIdentityProviderBuilder(openID); _visitables.get("openID").add(this.openID);} return (A) this;
    }

    public Boolean hasOpenID() {
        return this.openID != null;
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.OpenIDNested<A> withNewOpenID() {
        return new OpenIDNestedImpl();
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.OpenIDNested<A> withNewOpenIDLike(OpenIDIdentityProvider item) {
        return new OpenIDNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.OpenIDNested<A> editOpenID() {
        return withNewOpenIDLike(getOpenID());
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.OpenIDNested<A> editOrNewOpenID() {
        return withNewOpenIDLike(getOpenID() != null ? getOpenID(): new OpenIDIdentityProviderBuilder().build());
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.OpenIDNested<A> editOrNewOpenIDLike(OpenIDIdentityProvider item) {
        return withNewOpenIDLike(getOpenID() != null ? getOpenID(): item);
    }

    
/**
 * This method has been deprecated, please use method buildRequestHeader instead.
 * @return The buildable object.
 */
@Deprecated public RequestHeaderIdentityProvider getRequestHeader() {
        return this.requestHeader!=null?this.requestHeader.build():null;
    }

    public RequestHeaderIdentityProvider buildRequestHeader() {
        return this.requestHeader!=null?this.requestHeader.build():null;
    }

    public A withRequestHeader(RequestHeaderIdentityProvider requestHeader) {
        _visitables.get("requestHeader").remove(this.requestHeader);
        if (requestHeader!=null){ this.requestHeader= new RequestHeaderIdentityProviderBuilder(requestHeader); _visitables.get("requestHeader").add(this.requestHeader);} return (A) this;
    }

    public Boolean hasRequestHeader() {
        return this.requestHeader != null;
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.RequestHeaderNested<A> withNewRequestHeader() {
        return new RequestHeaderNestedImpl();
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.RequestHeaderNested<A> withNewRequestHeaderLike(RequestHeaderIdentityProvider item) {
        return new RequestHeaderNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.RequestHeaderNested<A> editRequestHeader() {
        return withNewRequestHeaderLike(getRequestHeader());
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.RequestHeaderNested<A> editOrNewRequestHeader() {
        return withNewRequestHeaderLike(getRequestHeader() != null ? getRequestHeader(): new RequestHeaderIdentityProviderBuilder().build());
    }

    public io.fabric8.openshift.api.model.IdentityProviderFluent.RequestHeaderNested<A> editOrNewRequestHeaderLike(RequestHeaderIdentityProvider item) {
        return withNewRequestHeaderLike(getRequestHeader() != null ? getRequestHeader(): item);
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type=type; return (A) this;
    }

    public Boolean hasType() {
        return this.type != null;
    }

    public A withNewType(StringBuilder arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(int[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(char[] arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(byte[] arg1,int arg2) {
        return (A)withType(new String(arg1, arg2));
    }

    public A withNewType(byte[] arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(char[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(byte[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withType(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewType(String arg1) {
        return (A)withType(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        IdentityProviderFluentImpl that = (IdentityProviderFluentImpl) o;
        if (basicAuth != null ? !basicAuth.equals(that.basicAuth) :that.basicAuth != null) return false;
        if (github != null ? !github.equals(that.github) :that.github != null) return false;
        if (gitlab != null ? !gitlab.equals(that.gitlab) :that.gitlab != null) return false;
        if (google != null ? !google.equals(that.google) :that.google != null) return false;
        if (htpasswd != null ? !htpasswd.equals(that.htpasswd) :that.htpasswd != null) return false;
        if (keystone != null ? !keystone.equals(that.keystone) :that.keystone != null) return false;
        if (ldap != null ? !ldap.equals(that.ldap) :that.ldap != null) return false;
        if (mappingMethod != null ? !mappingMethod.equals(that.mappingMethod) :that.mappingMethod != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (openID != null ? !openID.equals(that.openID) :that.openID != null) return false;
        if (requestHeader != null ? !requestHeader.equals(that.requestHeader) :that.requestHeader != null) return false;
        if (type != null ? !type.equals(that.type) :that.type != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(basicAuth,  github,  gitlab,  google,  htpasswd,  keystone,  ldap,  mappingMethod,  name,  openID,  requestHeader,  type,  super.hashCode());
    }

    public class BasicAuthNestedImpl<N> extends BasicAuthIdentityProviderFluentImpl<io.fabric8.openshift.api.model.IdentityProviderFluent.BasicAuthNested<N>> implements io.fabric8.openshift.api.model.IdentityProviderFluent.BasicAuthNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final BasicAuthIdentityProviderBuilder builder;

            BasicAuthNestedImpl(BasicAuthIdentityProvider item) {
                this.builder = new BasicAuthIdentityProviderBuilder(this, item);
                        
            }

            BasicAuthNestedImpl() {
                this.builder = new BasicAuthIdentityProviderBuilder(this);
                        
            }

            public N and() {
                return (N) IdentityProviderFluentImpl.this.withBasicAuth(builder.build());
            }

            public N endBasicAuth() {
                return and();
            }
    }


    public class GithubNestedImpl<N> extends GitHubIdentityProviderFluentImpl<io.fabric8.openshift.api.model.IdentityProviderFluent.GithubNested<N>> implements io.fabric8.openshift.api.model.IdentityProviderFluent.GithubNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final GitHubIdentityProviderBuilder builder;

            GithubNestedImpl(GitHubIdentityProvider item) {
                this.builder = new GitHubIdentityProviderBuilder(this, item);
                        
            }

            GithubNestedImpl() {
                this.builder = new GitHubIdentityProviderBuilder(this);
                        
            }

            public N and() {
                return (N) IdentityProviderFluentImpl.this.withGithub(builder.build());
            }

            public N endGithub() {
                return and();
            }
    }


    public class GitlabNestedImpl<N> extends GitLabIdentityProviderFluentImpl<io.fabric8.openshift.api.model.IdentityProviderFluent.GitlabNested<N>> implements io.fabric8.openshift.api.model.IdentityProviderFluent.GitlabNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final GitLabIdentityProviderBuilder builder;

            GitlabNestedImpl(GitLabIdentityProvider item) {
                this.builder = new GitLabIdentityProviderBuilder(this, item);
                        
            }

            GitlabNestedImpl() {
                this.builder = new GitLabIdentityProviderBuilder(this);
                        
            }

            public N and() {
                return (N) IdentityProviderFluentImpl.this.withGitlab(builder.build());
            }

            public N endGitlab() {
                return and();
            }
    }


    public class GoogleNestedImpl<N> extends GoogleIdentityProviderFluentImpl<io.fabric8.openshift.api.model.IdentityProviderFluent.GoogleNested<N>> implements io.fabric8.openshift.api.model.IdentityProviderFluent.GoogleNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final GoogleIdentityProviderBuilder builder;

            GoogleNestedImpl(GoogleIdentityProvider item) {
                this.builder = new GoogleIdentityProviderBuilder(this, item);
                        
            }

            GoogleNestedImpl() {
                this.builder = new GoogleIdentityProviderBuilder(this);
                        
            }

            public N and() {
                return (N) IdentityProviderFluentImpl.this.withGoogle(builder.build());
            }

            public N endGoogle() {
                return and();
            }
    }


    public class HtpasswdNestedImpl<N> extends HTPasswdIdentityProviderFluentImpl<io.fabric8.openshift.api.model.IdentityProviderFluent.HtpasswdNested<N>> implements io.fabric8.openshift.api.model.IdentityProviderFluent.HtpasswdNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final HTPasswdIdentityProviderBuilder builder;

            HtpasswdNestedImpl(HTPasswdIdentityProvider item) {
                this.builder = new HTPasswdIdentityProviderBuilder(this, item);
                        
            }

            HtpasswdNestedImpl() {
                this.builder = new HTPasswdIdentityProviderBuilder(this);
                        
            }

            public N and() {
                return (N) IdentityProviderFluentImpl.this.withHtpasswd(builder.build());
            }

            public N endHtpasswd() {
                return and();
            }
    }


    public class KeystoneNestedImpl<N> extends KeystoneIdentityProviderFluentImpl<io.fabric8.openshift.api.model.IdentityProviderFluent.KeystoneNested<N>> implements io.fabric8.openshift.api.model.IdentityProviderFluent.KeystoneNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KeystoneIdentityProviderBuilder builder;

            KeystoneNestedImpl(KeystoneIdentityProvider item) {
                this.builder = new KeystoneIdentityProviderBuilder(this, item);
                        
            }

            KeystoneNestedImpl() {
                this.builder = new KeystoneIdentityProviderBuilder(this);
                        
            }

            public N and() {
                return (N) IdentityProviderFluentImpl.this.withKeystone(builder.build());
            }

            public N endKeystone() {
                return and();
            }
    }


    public class LdapNestedImpl<N> extends LDAPIdentityProviderFluentImpl<io.fabric8.openshift.api.model.IdentityProviderFluent.LdapNested<N>> implements io.fabric8.openshift.api.model.IdentityProviderFluent.LdapNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LDAPIdentityProviderBuilder builder;

            LdapNestedImpl(LDAPIdentityProvider item) {
                this.builder = new LDAPIdentityProviderBuilder(this, item);
                        
            }

            LdapNestedImpl() {
                this.builder = new LDAPIdentityProviderBuilder(this);
                        
            }

            public N and() {
                return (N) IdentityProviderFluentImpl.this.withLdap(builder.build());
            }

            public N endLdap() {
                return and();
            }
    }


    public class OpenIDNestedImpl<N> extends OpenIDIdentityProviderFluentImpl<io.fabric8.openshift.api.model.IdentityProviderFluent.OpenIDNested<N>> implements io.fabric8.openshift.api.model.IdentityProviderFluent.OpenIDNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final OpenIDIdentityProviderBuilder builder;

            OpenIDNestedImpl(OpenIDIdentityProvider item) {
                this.builder = new OpenIDIdentityProviderBuilder(this, item);
                        
            }

            OpenIDNestedImpl() {
                this.builder = new OpenIDIdentityProviderBuilder(this);
                        
            }

            public N and() {
                return (N) IdentityProviderFluentImpl.this.withOpenID(builder.build());
            }

            public N endOpenID() {
                return and();
            }
    }


    public class RequestHeaderNestedImpl<N> extends RequestHeaderIdentityProviderFluentImpl<io.fabric8.openshift.api.model.IdentityProviderFluent.RequestHeaderNested<N>> implements io.fabric8.openshift.api.model.IdentityProviderFluent.RequestHeaderNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final RequestHeaderIdentityProviderBuilder builder;

            RequestHeaderNestedImpl(RequestHeaderIdentityProvider item) {
                this.builder = new RequestHeaderIdentityProviderBuilder(this, item);
                        
            }

            RequestHeaderNestedImpl() {
                this.builder = new RequestHeaderIdentityProviderBuilder(this);
                        
            }

            public N and() {
                return (N) IdentityProviderFluentImpl.this.withRequestHeader(builder.build());
            }

            public N endRequestHeader() {
                return and();
            }
    }


}
