package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface ImageStreamImportStatusFluent<A extends ImageStreamImportStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public A addToImages(int index,ImageImportStatus item);
    public A setToImages(int index,ImageImportStatus item);
    public A addToImages(ImageImportStatus... items);
    public A addAllToImages(Collection<ImageImportStatus> items);
    public A removeFromImages(ImageImportStatus... items);
    public A removeAllFromImages(Collection<ImageImportStatus> items);
    public A removeMatchingFromImages(Predicate<ImageImportStatusBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildImages instead.
 * @return The buildable object.
 */
@Deprecated public List<ImageImportStatus> getImages();
    public List<ImageImportStatus> buildImages();
    public ImageImportStatus buildImage(int index);
    public ImageImportStatus buildFirstImage();
    public ImageImportStatus buildLastImage();
    public ImageImportStatus buildMatchingImage(Predicate<ImageImportStatusBuilder> predicate);
    public Boolean hasMatchingImage(Predicate<ImageImportStatusBuilder> predicate);
    public A withImages(List<ImageImportStatus> images);
    public A withImages(ImageImportStatus... images);
    public Boolean hasImages();
    public io.fabric8.openshift.api.model.ImageStreamImportStatusFluent.ImagesNested<A> addNewImage();
    public io.fabric8.openshift.api.model.ImageStreamImportStatusFluent.ImagesNested<A> addNewImageLike(ImageImportStatus item);
    public io.fabric8.openshift.api.model.ImageStreamImportStatusFluent.ImagesNested<A> setNewImageLike(int index,ImageImportStatus item);
    public io.fabric8.openshift.api.model.ImageStreamImportStatusFluent.ImagesNested<A> editImage(int index);
    public io.fabric8.openshift.api.model.ImageStreamImportStatusFluent.ImagesNested<A> editFirstImage();
    public io.fabric8.openshift.api.model.ImageStreamImportStatusFluent.ImagesNested<A> editLastImage();
    public io.fabric8.openshift.api.model.ImageStreamImportStatusFluent.ImagesNested<A> editMatchingImage(Predicate<ImageImportStatusBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildImport instead.
 * @return The buildable object.
 */
@Deprecated public ImageStream getImport();
    public ImageStream buildImport();
    public A withImport(ImageStream _import);
    public Boolean hasImport();
    public io.fabric8.openshift.api.model.ImageStreamImportStatusFluent.ImportNested<A> withNewImport();
    public io.fabric8.openshift.api.model.ImageStreamImportStatusFluent.ImportNested<A> withNewImportLike(ImageStream item);
    public io.fabric8.openshift.api.model.ImageStreamImportStatusFluent.ImportNested<A> editImport();
    public io.fabric8.openshift.api.model.ImageStreamImportStatusFluent.ImportNested<A> editOrNewImport();
    public io.fabric8.openshift.api.model.ImageStreamImportStatusFluent.ImportNested<A> editOrNewImportLike(ImageStream item);
    
/**
 * This method has been deprecated, please use method buildRepository instead.
 * @return The buildable object.
 */
@Deprecated public RepositoryImportStatus getRepository();
    public RepositoryImportStatus buildRepository();
    public A withRepository(RepositoryImportStatus repository);
    public Boolean hasRepository();
    public io.fabric8.openshift.api.model.ImageStreamImportStatusFluent.RepositoryNested<A> withNewRepository();
    public io.fabric8.openshift.api.model.ImageStreamImportStatusFluent.RepositoryNested<A> withNewRepositoryLike(RepositoryImportStatus item);
    public io.fabric8.openshift.api.model.ImageStreamImportStatusFluent.RepositoryNested<A> editRepository();
    public io.fabric8.openshift.api.model.ImageStreamImportStatusFluent.RepositoryNested<A> editOrNewRepository();
    public io.fabric8.openshift.api.model.ImageStreamImportStatusFluent.RepositoryNested<A> editOrNewRepositoryLike(RepositoryImportStatus item);
    public interface ImagesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageImportStatusFluent<io.fabric8.openshift.api.model.ImageStreamImportStatusFluent.ImagesNested<N>> {

            public N and();
            public N endImage();    }


    public interface ImportNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageStreamFluent<io.fabric8.openshift.api.model.ImageStreamImportStatusFluent.ImportNested<N>> {

            public N and();
            public N endImport();    }


    public interface RepositoryNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RepositoryImportStatusFluent<io.fabric8.openshift.api.model.ImageStreamImportStatusFluent.RepositoryNested<N>> {

            public N and();
            public N endRepository();    }


}
